<?php
namespace App\Http\Controllers;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;

class Slack
{
    var $project;
    var $request;
    protected $_param;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    //outgoing webhook
    //get app credentials from here: https://api.slack.com/apps/AAHDRPPRU
    public function postDueDates($project = "CE", $type = "test")
    {
        $url = "https://hooks.slack.com/services/";
        $text = "*" . Config::get("$project.slack.name") ." Release Dates*\r";
        if ($type == "test") {
            $postURL = Config::get("$project.slack.webhooks.test");
        } else if ($type = "final-external") {
            $postURL = Config::get("$project.slack.webhooks.final-external");
        } else {
            //final-internal slack channel
            $postURL = Config::get("$project.slack.webhooks.final-internal");
        }

        //get WPU issues
        $wpu = new WPU($this->request);
        $issues = $wpu->getWPUJIRAItems($project);

        foreach ($issues as $issue) {
            $text .= "• <https://jira.twitch.com/browse/" . $issue->key . "|" . $issue->fields->summary . "> => ";
            if (isset($issue->fields->duedate)) {
                $text .= Carbon::parse($issue->fields->duedate)->format('D, M d');
            } else {
                $text .= "TBD";
            }
            $text .= "\r";
        }

        $footer = Config::get("$project.slack.footer");
        $client = new Client([
            // Base URI is used with relative requests
            'base_uri' => $url,
            // You can set any number of default request options.
            'timeout'  => 2.0,
        ]);

        $response = $client->request('POST', $postURL,[
                'json' => [
                    'mrkdown' => true,
                    'text' => $text,
                    'attachments' => [$footer]
                ],
                'options' => [
                    'exceptions' => false
                ]
            ]
        );

        echo "<pre>" . $response->getStatusCode() . "\n\r" . htmlentities($text) . "</pre>";
    }

    //outgoing webhook
    public function postOEItems($project = "CE", $type) {

        $url = "https://hooks.slack.com/services/";
        $text = "*" . Config::get("$project.slack.name") . " Security Tickets*\r";

        if ($type == "test") {
            $postURL = Config::get("$project.slack.webhooks.test");
        } else if ($type = "final-external") {
            $postURL = Config::get("$project.slack.webhooks.final-external");
        } else {
            //final-internal slack channel
            $postURL = Config::get("$project.slack.webhooks.final-internal");
        }

        $wpu = new WPU($this->request);
        $issues = $wpu->getOEJIRAItems($project);
        $text .= "# of Issues: " . count($issues) . "\r";

        $attachments = array();

        foreach ($issues as $issue) {
            //regular text update
//            $text .= "• <https://jira.twitch.com/browse/" . $issue->key . "|" . $issue->fields->summary . "> => ";
//            if (isset($issue->fields->duedate)) {
//                $text .= Carbon::parse($issue->fields->duedate)->format('D, M d');
//            } else {
//                $text .= "TBD";
//            }
//            $text .= "\r";

            $link = "https://jira.twitch.com/browse/" . $issue->key;


            $attachments[] = array(
                "fallback" => $issue->key,
                "color" => "#423071",
//                "pretext" => $issue->fields->summary,
//                "author_name" => "Product and Science Team",
//                "author_link" => "https://modeanalytics.com/twitch/reports/6e284acd134a",
                "author_icon" => "http://flickr.com/icons/bobby.jpg",
                "title" => $issue->key . " " . $issue->fields->summary,
                "title_link" => $link,
//                "text" => "Optional text that appears within the attachment",
                "image_url" => "http://my-website.com/path/to/image.jpg",
                "thumb_url" => "http://example.com/path/to/thumb.png",
                "footer" => $issue->fields->assignee->displayName . " (" . $issue->fields->status->name . ")",
                "footer_icon" => "https://static-cdn.jtvnw.net/emoticons/v1/160403/3.0"
//                "ts" => 123456789
            );
        }
        $client = new Client([
            // Base URI is used with relative requests
            'base_uri' => $url,
            // You can set any number of default request options.
            'timeout'  => 2.0,
        ]);
        
        try {
            $response = $client->request('POST', $postURL,[
                    'json' => [
                        'mrkdown' => true,
                        'text' => $text,
                        'attachments' => $attachments
                    ],
                    'options' => [
                        'exceptions' => true
                    ]
                ]
            );
            echo "<pre>" . $response->getStatusCode() . "\n\r" . htmlentities($text) . "</pre>";
        } catch (RequestException $e) {
            echo Psr7\str($e->getRequest());
            if ($e->hasResponse()) {
                echo Psr7\str($e->getResponse());
            }
        }
    }

    //outgoing webhook
    public function postModeData($project = "CE", $type) {
        $url = "https://hooks.slack.com/services/";
        $text = "*Spotlight Staff Stats*\r";

        if ($type == "test") {
            $postURL = Config::get("$project.slack.webhooks.test");
        } else if ($type = "final-external") {
//            $postURL = Config::get("$project.slack.webhooks.final-external");
            $postURL = "T0266V6GF/BLJ83GVRR/tK7v6MROi24NkzOqJpHCz1RM";
        } else {
            //final-internal slack channel
//            $postURL = Config::get("$project.slack.webhooks.final-internal");
            $postURL = "T0266V6GF/BLJ83GVRR/tK7v6MROi24NkzOqJpHCz1RM";
        }

        $wpu = new WPU($this->request);
        $mode = $wpu->getModeQueryData("https://modeanalytics.com/api/twitch/reports/a1ee4f1019cd/runs/c94e2842ee5d/query_runs/5db5c96382a3/results/content.json");

        //take only data from the last 4 weeks
        foreach($mode as $key => $data) {
            $week = Carbon::createFromTimeString($data->week);
            if(Carbon::now()->subWeek(4)->lte($week)) {
//                $text .= $week->format("M d") . "channels " . "minute broadcast ";

                $attachments[] = array(
                    "fallback" => "Week of " . $week->format("M d"),
                    "color" => "#423071",
                    "pretext" => "Week of " . $week->format("M d"),
//                    "author_name" => "Spotlight Team",
                    "author_link" => "https://modeanalytics.com/twitch/reports/a1ee4f1019cd",
                    "author_icon" => "http://flickr.com/icons/bobby.jpg",
                    "title" => "# of channels: " . $data->channels . "\r" . "minutes broadcast: " . $data->mb,
//                    "title_link" => $link,
//                    "text" => "Optional text that appears within the attachment",
                    "image_url" => "http://my-website.com/path/to/image.jpg",
                    "thumb_url" => "http://example.com/path/to/thumb.png",
//                    "footer" => $issue->fields->assignee->displayName . " (" . $issue->fields->status->name . ")",
                    "footer_icon" => "https://static-cdn.jtvnw.net/emoticons/v1/160403/3.0"
//                "ts" => 123456789
                );
            }
        }

        $client = new Client([
            // Base URI is used with relative requests
            'base_uri' => $url,
            // You can set any number of default request options.
            'timeout'  => 2.0,
        ]);

        try {
            $response = $client->request('POST', $postURL,[
                    'json' => [
                        'mrkdown' => true,
                        'text' => $text,
                        'attachments' => $attachments
                    ],
                    'options' => [
                        'exceptions' => true
                    ]
                ]
            );
            echo "<pre>" . $response->getStatusCode() . "\n\r" . htmlentities($text) . "</pre>";
        } catch (RequestException $e) {
            echo Psr7\str($e->getRequest());
            if ($e->hasResponse()) {
                echo Psr7\str($e->getResponse());
            }
        }
    }
}