<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

//Look back at launched items for the current year
class StoryPoints extends BaseController
{

    //create and show WPU page for an individual team
    //default to 'ce' if no key set
    //which team = jira project to filter to
    public function showStoryPoints($project = "ce", $team = "tcp", $weeks = "12")
    {
        $template = "storypoints"; //launched.blade.php
        list($points, $storyDetails) = $this->getStoryPoints($project, $team, $weeks);
        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name') . ": " . strtoupper($team),
                'points' => $points,
                'weeks' => $weeks,
                'storyDetails' => $storyDetails,
                'contacts' => Config::get($project .'.contacts'),
            )
        );
    }

    //jira rest call to show hours/days estimates breakdown in relation to story points
    public function getStoryPoints($project = "ce", $team = "CB", $weeks = "12")
    {
        //jira story points field = customfield_10105
        $jqlFragment = Config::get($project . ".jira.timespentJqlFragment");
        $weeks = "-" . $weeks . "w";
        $jql = "{
            \"jql\": \"'Story Points' is not EMPTY AND project = $team AND statusCategory = Done AND resolved > $weeks AND resolution not in (Duplicate)\",
            $jqlFragment
            } ";
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("YmdH");
        $key = md5("storypoints" . $today . "_" . $project . "_" . $jql);

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(30);
            $jira = new \Jira();
            try {
                $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            }
            catch(RequestException $e) {
                dd("Bad Configuration: ",  $e->getMessage());
            }
            catch (\Exception $e) {
                // There was another exception.
                dd("Bad Configuration: ",  $e->getMessage());
            }
            Cache::add($key, $results, $expiresAt);
        }
//        dd($results);
//        dd($results->issues[0]->changelog->histories);
//        dd(\Jira::getTimeSpentForOneStory($results->issues[1]->changelog->histories));

        foreach($results->issues as $k => $v) {
//            dd($v->fields->customfield_10105);
            if(\Jira::getTimeSpentForOneStory($v->changelog->histories) != 0) {
                $points[$v->fields->customfield_10105][$v->key] = \Jira::getTimeSpentForOneStory($v->changelog->histories);
                $storyDetails[$v->key] = array(
                    "summary" => $v->fields->summary,
                    "resolution" => $v->fields->resolution->name
                    );
            }
        }

        ksort($points);
        foreach($points as $k => $v) {
            asort($points[$k]);
        }
//        dd($points);
//        dd($storyDetails);
        return array($points, $storyDetails);
    }
}