<?php
namespace App\Http\Controllers;
use GuzzleHttp\Client;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use Zend\Log\Writer\Mail;

define('EXPIRY', 5); //how many minutes?)
define('DEBUG', TRUE); //how many minutes?)
date_default_timezone_set('America/Los_Angeles');

//dd(date_default_timezone_get());
//Agile REST API: https://docs.atlassian.com/greenhopper/REST/cloud/
//JIRA REST API: https://docs.atlassian.com/jira/REST/latest/#d2e4004


//Application Link Name: twitchtpm
//Keypair: (Attached)
//Consumer Key: twitchtpm
//Consumer Name: twitchtpm
//Service Account Name: srvc-jira-twitchtpm
class WPU extends BaseController
{
    var $modeGraphs;
    var $project;
    protected $_param;

    public function __construct(Request $request)
    {
//        $$this->project = $request->get("project");
    }

    //create and show WPU page for an individual team
    //default to 'ce' if no key set
    public function showWPUItems($project = "ce")
    {
        $wpuDigest = $this->getCurrentWPUDigest($project);
        $this->getLastSuccessfulModeRun($project);
        $insight = $this->getInsightsForTheWeek($project);
        $template = Config::get($project . '.projectinfo.bladeTemplate');
//        dd($this->modeGraphs); //uncomment to debug

        return View::make($template,
            array(
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name'),
                'issues' => $this->getWPUJIRAItems($project),
                'launched' => $this->getLaunchedItems($project),
                'roadmap' => $this->getRoadmapItems($project),
                'modeGraphs' => $this->modeGraphs,
                'wpuDigest' => $wpuDigest,
                'wbrMetricsText' =>  Config::get($project .'.modegraphs.wbrMetricsText'),
                'contacts' => Config::get($project .'.contacts'),
                'insight' => $insight,
                'graphJS' => ""
            )
        );
    }

    public function sendTeamWPUEmail($project = "ce") {
        $wpuDigest = $this->getCurrentWPUDigest($project);
        $this->getLastSuccessfulModeRun($project);
        $insight = $this->getInsightsForTheWeek($project);
        $template = Config::get($project . '.projectinfo.bladeTemplate');
//        dd($this->modeGraphs); //uncomment to debug

        $data = array(
            'project' => $project,
            'projectName' => Config::get($project . '.projectinfo.name'),
            'issues' => $this->getWPUJIRAItems($project),
            'launched' => $this->getLaunchedItems($project),
            'roadmap' => $this->getRoadmapItems($project),
            'modeGraphs' => $this->modeGraphs,
            'wpuDigest' => $wpuDigest,
            'wbrMetricsText' =>  Config::get($project .'.modegraphs.wbrMetricsText'),
            'contacts' => Config::get($project .'.contacts'),
            'insight' => $insight,
            'graphJS' => "image"
        );

        $toEmails = explode(',', env('MAIL_TO'));

        //send email
        \Illuminate\Support\Facades\Mail::send($template, $data, function($message) use ($project, $toEmails) {
            $emailSubject = "[test] " . Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
            $message->to($toEmails)->subject($emailSubject);
            $message->from(env('MAIL_USERNAME'));
        });
        return View::make($template, $data);
    }

    //company WPU email
    public function showCompanyWPU()
    {
        $project = "twitch";
        $wpuDigest = $this->getCurrentWPUDigest($project);
        $stls = $this->getSTLs($project);

        return View::make('companywpu',
            array(
                'stls' => $stls,
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name'),
                'issues' => $this->getWPUJIRAItems($project),
                'launched' => $this->getLaunchedItems($project),
                'red' => $this->getRedItems($project),
                'wpuDigest' => $wpuDigest,
                'contacts' => Config::get($project .'.contacts'),
            )
        );
    }

    //same as the showCompanyWPU function, but sends an email
    public function sendCompanyWPUEmail($type = "test"){
        $project = "twitch";
        $wpuDigest = $this->getCurrentWPUDigest($project);
        $stls = $this->getSTLs($project);
        $data = array('stls' => $stls,
                'project' => $project,
                'projectName' => Config::get($project . '.projectinfo.name'),
                'issues' => $this->getWPUJIRAItems($project),
                'launched' => $this->getLaunchedItems($project),
                'red' => $this->getRedItems($project),
                'wpuDigest' => $wpuDigest,
                'contacts' => Config::get($project .'.contacts'));

        //send email
        if ($type == "test") {
            //TEST EMAIL
            $toEmails = explode(',', env('MAIL_TO_TEST'));
            \Illuminate\Support\Facades\Mail::send('companywpu', $data, function ($message) use ($project, $toEmails) {
                $emailSubject = env('MAIL_SUBJECT_PREPEND_TEST') . Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
                $message->to($toEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        } elseif ($type == "final") {
            //FINAL EMAIL
            $toEmails = explode(',', env('MAIL_TO'));
            \Illuminate\Support\Facades\Mail::send('companywpu', $data, function ($message) use ($project, $toEmails) {
                $emailSubject = Config::get($project . '.projectinfo.name') . " (" . Carbon::today()->startOfWeek()->format('M d') . " - " . Carbon::today()->endOfWeek()->format('M d') . ")";
                $message->to($toEmails)->subject($emailSubject);
                $message->from(env('MAIL_FROM'));
            });
        }

        //show wpu on browser
        return View::make('companywpu', $data);
    }

    //get STLs from Google Sheets
    public function getSTLs($project) {
        if(Config::get($project . ".projectinfo.stl")) {
            $sheetID = Config::get($project . '.projectinfo.stl.sheetId');
            $sheetRange = Config::get($project . '.projectinfo.stl.sheetRange');
            $stls = \GoogleSheets::getGSheetData($sheetID, $sheetRange, 6); //how many columns of data are there beyond the key?
//            dd($stls);
            return $stls;
        }
    }

    //get current or last usable content for program update from wpudigests.php or pull it from a google sheet
    public function getCurrentWPUDigest($project){
        $Monday = (int)Carbon::today()->startOfWeek()->format('Ymd'); //get Monday and convert to integer
        $Sunday = (int)Carbon::today()->endOfWeek()->format('Ymd'); //get Sunday and convert to integer

        //use googlesheet
        if (Config::get($project . ".projectinfo.exec")) {
            $sheetID = Config::get($project . '.projectinfo.exec.sheetId');
            $sheetRange = Config::get($project . '.projectinfo.exec.sheetRange');
            $digests = \GoogleSheets::getGSheetData($sheetID, $sheetRange);
            $found = 0;
            $weeksAgo = 0;
            while ($found != 1) {
                foreach ($digests as $date => $digest) {
                    $date = (int)Carbon::parse($date)->format("Ymd");
                    if ($date <= $Sunday && $date >= $Monday) {
                        return $digest;
                    }
                }
                $Monday = (int)Carbon::today()->subWeek($weeksAgo)->startOfWeek()->format('Ymd');
                $Sunday = (int)Carbon::today()->subWeek($weeksAgo)->endOfWeek()->format('Ymd');
                $weeksAgo++;
            }
        //use old PHP configuration file
        } else {
            $key = $project . ".wpudigests";
            $digests = Config::get($key);
            $found = 0;
            $weeksAgo = 0;
            while ($found != 1) {
                foreach ($digests as $date => $digest) {
                    if ($date <= $Sunday && $date >= $Monday) {
                        return $digest;
                    }
                }
                $Monday = (int)Carbon::today()->subWeek($weeksAgo)->startOfWeek()->format('Ymd');
                $Sunday = (int)Carbon::today()->subWeek($weeksAgo)->endOfWeek()->format('Ymd');
                $weeksAgo++;
            }
        }
    }

    //JIRA CUSTOM FIELD NAMES
    //program update JIRA items
    //review date = customfield_15100
    //project status = customfield_17202
    //live date = customfield_13104
    //original deliverable date = customfield_18001
    //product spec = customfield_18201
    //project status summary = customfield_17802
    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    public function getWPUJIRAItems($project = "ce")
    {
        $jql = Config::get($project .'.jira.jql');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "jira" . $today . "_" . $project . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(2);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
//
//        //for debugging purposes ONLY.  use hard coded file
//        $filename = "/Users/jon/Documents/Twitch/wpu/config/" . $project . "/test-search.json";
//        $string = file_get_contents($filename, true);
//        $results = json_decode($string);
        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    public function getLaunchedItems($project = "ce")
    {
        $jql = Config::get($project .'.jira.launchedJql');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "launched" . $today . "_" . $project . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(2);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
//
//        //for debugging purposes ONLY.  use hard coded file
//        $filename = "/Users/jon/Documents/Twitch/wpu/config/" . $project . "/test-search.json";
//        $string = file_get_contents($filename, true);
//        $results = json_decode($string);
        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    public function getRedItems($project = "ce")
    {
        $jql = Config::get($project .'.jira.redJql');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "red" . $today . "_" . $project . "_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(2);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }

//        dd($results);
//
//        //for debugging purposes ONLY.  use hard coded file
//        $filename = "/Users/jon/Documents/Twitch/wpu/config/" . $project . "/test-search.json";
//        $string = file_get_contents($filename, true);
//        $results = json_decode($string);
        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //Metrics Prediction = customfield_19701
    //Metrics Actual = customfield_19702
    public function getRoadmapItems($project = "ce")
    {
        $jql = Config::get($project .'.jira.roadmapJql');
        if (isset($jql)) {
            $consumerKey = Config::get($project . '.jira.consumerKey');
            $oauthToken = env("JIRA_OAUTH_TOKEN");
            $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
            $baseURI = Config::get($project . '.jira.baseURI');

            $today = date("Ymd");
            $key = "roadmap" . $today . "_" . $project . "_" . $project;

            if (Cache::has($key) && DEBUG) {
                $results = Cache::get($key);
            } else {
                $expiresAt = \Carbon\Carbon::now()->addMinutes(5);
                $jira = new \Jira();
                $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
                Cache::add($key, $results, $expiresAt);
            }

//        dd($results);
//
//        //for debugging purposes ONLY.  use hard coded file
//        $filename = "/Users/jon/Documents/Twitch/wpu/config/" . $project . "/test-search.json";
//        $string = file_get_contents($filename, true);
//        $results = json_decode($string);
            if (isset($results->issues)) {
                return $results->issues;
            } else {
                return array();
            }
        } else {
            return array();
        }
    }

    //operation excellence tickets
    public function getOEJIRAItems($project = "ce")
    {
        $jql = Config::get($project .'.jira.securityJql');
        $consumerKey = Config::get($project .'.jira.consumerKey');
        $oauthToken = env("JIRA_OAUTH_TOKEN");
        $oauthTokenSecret = env("JIRA_OAUTH_SECRET");
        $baseURI = Config::get($project . '.jira.baseURI');

        $today = date("Ymd");
        $key = "jira" . $today . "_" . $project . "_OE_" . $project;

        if (Cache::has($key) && DEBUG) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(2);
            $jira = new \Jira();
            $results = json_decode($jira->post($oauthToken, $oauthTokenSecret, $consumerKey, $baseURI, "search", $jql));
            Cache::add($key, $results, $expiresAt);
        }
//
//        //for debugging purposes ONLY.  use hard coded file
//        $filename = "/Users/jon/Documents/Twitch/wpu/config/" . $project . "/test-search.json";
//        $string = file_get_contents($filename, true);
//        $results = json_decode($string);
        if(isset($results->issues)) {
            return $results->issues;
        } else {
            return array();
        }
    }

    //pull from google sheet from designated tab
    public function getInsightsForTheWeek($project) {
        $sheetID = Config::get($project . '.projectinfo.insights.sheetId');
        if (isset($sheetID)) {
            $sheetRange = Config::get($project . '.projectinfo.insights.sheetRange');
            $insights = \GoogleSheets::getGSheetData($sheetID, $sheetRange);

            $Monday = (int)Carbon::today()->startOfWeek()->format('Ymd'); //get Monday and convert to integer
            $Sunday = (int)Carbon::today()->endOfWeek()->format('Ymd'); //get Sunday and convert to integer
            $found = 0;
            $weeksAgo = 0;
            while ($found != 1) {
                foreach ($insights as $date => $insight) {
                    $date = (int)Carbon::parse($date)->format("Ymd");
                    if ($date <= $Sunday && $date >= $Monday) {
                        return $insight;
                    }
                }
                $Monday = (int)Carbon::today()->subWeek($weeksAgo)->startOfWeek()->format('Ymd');
                $Sunday = (int)Carbon::today()->subWeek($weeksAgo)->endOfWeek()->format('Ymd');
                $weeksAgo++;
            }
        }
    }

    //creator experience dashboard https://modeanalytics.com/api/twitch/reports/6e284acd134a
    //get the last successful query run for each query in the modeGraph object
    public function getLastSuccessfulModeRun($project = "ce") {
        $this->modeGraphs = Config::get($project .  '.modegraphs.graphs');

        foreach($this->modeGraphs as $reportName => $graph) {
            $today = date("Ymd");
            $key = "mode" . $today . "_" . mb_ereg_replace(" ", "_", "$reportName");
            $url = $graph['mode'] . "/queries/" . $graph['queryToken'] . "/runs";
            if (Cache::has($key)) {
                $results = Cache::get($key);
            } else {
                $expiresAt = \Carbon\Carbon::now()->addMinutes(5);
                $mode = new \Mode();
                $results = json_decode($mode->get($url), false);
                Cache::add($key, $results, $expiresAt);
            }

            $runs = $results->_embedded->query_runs;
            foreach($runs as $run) {
                if($run->state == 'succeeded') {
                    $queryURL = "https://modeanalytics.com" . $run->_links->result->href;
                    $key = "mode" . $today . "_" . mb_ereg_replace(" ", "_", "$queryURL");
                    if (Cache::has($key)) {
                        $queryResults = Cache::get($key);
                    } else {
                        $expiresAt = \Carbon\Carbon::now()->addMinutes(5);
                        $mode = new \Mode();
                        $queryResults = json_decode($mode->get($queryURL), false);
                        Cache::add($key, $queryResults, $expiresAt);
                    }
                    $queryURL = (substr($queryResults->_links->csv->href, 0, -3)); //strip off csv
                    $this->modeGraphs[$reportName]['jsonResponse'] =  $queryURL . "json"; //extension can be .csv or .json
                    break;
                }
            }
        }
//        dd($this->modeGraphs);
        return $this->modeGraphs;
    }


    //create graphs data based on URL parameters
    public function createGraphData($project = "ce", $token = "10") {
        $this->getLastSuccessfulModeRun($project);
        $url = $this->modeGraphs[$token]['jsonResponse'];
        $results = $this->getModeQueryData($url);

//        dd($results);
        //get target if it exists and using CSV
        if (isset($this->modeGraphs[$token]['target'])) {
            $target = \Helpers::makeArrayFromCSV($this->modeGraphs[$token]['target']['fileName']);
            $dateName = $this->modeGraphs[$token]['target']['dateFieldName'];
            $valueName = $this->modeGraphs[$token]['target']['targetFieldName'];
        } else {
            $target = "";
            $dateName = "";
            $valueName = "";
        }

        $this->createGraph($this->modeGraphs[$token]['haxis'],$this->modeGraphs[$token]['vaxis'], $results, $target, $dateName, $valueName);
    }


    //query via REST at https://modeanalytics.com/api/
    //sort by date
    public function getModeQueryData($url) {
        $today = date("Ymd");
        $key = "mode" . $today . "_" . mb_ereg_replace(" ", "_", "$url");


        if (Cache::has($key)) {
            $results = Cache::get($key);
        } else {
            $expiresAt = \Carbon\Carbon::now()->addMinutes(5);
            $mode = new \Mode();
            $results = json_decode($mode->get($url), false);
            Cache::add($key, $results, $expiresAt);
        }

        //sort by first field
        usort($results, function($a, $b) {
            return $a > $b ? 1 : -1; //Compare the scores
        });
//        dd($results);
        return $results;
    }


    //just for testing purposes
    public function getModeQueryDataWithLocalFile($file) {
        $filename = dirname(__FILE__) . $file;
        $string = file_get_contents($filename, true);
        $string = \Helpers::remove_utf8_bom($string);
        $jsonResponse = json_decode($string);

        //sort by first field
        usort($jsonResponse, function($a, $b) {
            return $a > $b ? 1 : -1; //Compare the scores
        });
        return $jsonResponse;
    }


    //create google charts graph data that can be consumed via REST
    public function createGraph($x, $y, $json, $target = "", $x2 = "", $y2 = "") {
        $table['cols'][] = array('id' => $x, 'label' => $x, 'type' => 'date');
        $table['cols'][] = array('id' => $y, 'label' => $y, 'type' => 'number');
        if ($target != "") {
            $table['cols'][] = array('id' => 'target', 'label' => 'target', 'type' => 'number'); //target
        }
//        array_pop($json);
        $rows = $this->createRowDataForGoogleChart($json, $x, $y, $target, $x2, $y2);
        // populate the table with rows of data
        $table['rows'] = $rows;
        // encode the table as JSON
        $jsonTable = json_encode($table, JSON_NUMERIC_CHECK);
        echo $jsonTable;
    }

    //helper function to create row data for Google Chart
    //added target date + x,y names
    public function createRowDataForGoogleChart($data, $timeName, $valueName, $targets = "", $timeName2 = "", $valueName2 = "") {
        $rows = array();

        //if target is set
        if ($targets != "") {
//            dd($data); //2017-09-25T00:00:00.000Z
            $targetAssoc = array();

            //convert to associative array with date keys
            foreach ($targets as $target) {
                $date = $target[$timeName2];
                $date = Carbon::Parse($date)->setTimeZone('UTC')->setTime(0, 0, 0)->toIso8601ZuluString();
                $targetAssoc[$date] = $target; //create associative array
            }
//            dd($targetAssoc); //shows what the CSV Targets
        }


//        dd($data);
        foreach($data as $values) {
            $temp = array();
            $date = Carbon::Parse($values->$timeName);

            //TODO: only add values greater than last 6 months
            $thisYear = Carbon::now()->subMonth(6);
            if ($date->greaterThan($thisYear)) {
                $year = date("Y", strtotime($date));
                $month = date("m", strtotime($date)) - 1; //pass to javascript so need to subtract 1 because months start at 0 for January
                $day = date("d", strtotime($date)) + 1;
                $jsdate = "Date($year, $month, $day)";
                $temp[] = array('v' => $jsdate, 'f' => date("D M d, Y", strtotime($date . "+1 day")));
                $temp[] = array('v' => $values->$valueName);


                if ($targets != "") {
                    if(array_key_exists($date->toIso8601ZuluString(), $targetAssoc)) {
                        $temp[] = array('v'=> str_replace(",", "", $targetAssoc[$date->toIso8601ZuluString()][$valueName2])); //add target values
                        array_shift($targetAssoc);
                    }
                }
                $rows[] = array('c' => $temp);
            }
        }

        //if target is set
        if ($targets != "" && count($targetAssoc) > 0) {
            array_shift($targetAssoc);
            foreach($targetAssoc as $target) {
                $temp = array();
                $date = Carbon::Parse($target["date"]);
                $year = date("Y", strtotime($date));
                $month = date("m", strtotime($date)) - 1; //pass to javascript so need to subtract 1 because months start at 0 for January
                $day = date("d", strtotime($date)) + 1;
                $jsdate = "Date($year, $month, $day)";
                $temp[] = array('v' => $jsdate, 'f' => date("D M d, Y", strtotime($date . "+1 day")));
                $temp[] = array('v' => null);
                $temp[] = array('v'=> str_replace(",", "", $target["target"])); //add target values
                $rows[] = array('c' => $temp);
            }
        }

        return $rows;
    }

}
