<?php
return array(
    'consumerKey' => 'twitchtpm',
    'baseURI' => "https://jira.xarth.tv/rest/api/2/",
    'projects' => "CB, EV, TCP",
    'jql' => '
    {
        "jql": "project in (TCP, EV, CB, MCN, SLP, CE) AND issuetype in (epic, story, \"Project Plan\", initiative) and resolution = unresolved and labels = wpu and (duedate > startOfDay() or duedate is empty) ORDER BY duedate ASC",
	"maxResults" : 1000,
	"fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "parent",
        "issuelinks",
        "labels",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ]
}',
    'launchedJql' => '
    {
    "jql": "labels in (wpu) AND project in (EV, TCP, CB, CE, MCN, SLP) AND duedate  >= -15d and duedate <= 0d ORDER BY duedate  DESC",
    "maxResults" : 1000,
    "fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "parent",
        "issuelinks",
        "labels",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ]
}',
    'roadmapJql' => '
    {
    "jql": "labels in (roadmap) AND labels not in (wpu, oe) AND project in (EV, TCP, CB, CE, MCN, SLP) and resolution is EMPTY and status not in (\"Launch [8]\", \"Analysis Complete [9]\") ORDER BY due ASC, status ASC",
    "maxResults" : 1000,
    "fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "parent",
        "issuelinks",
        "labels",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_21324",
        "customfield_21750"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "status",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_21324",
        "customfield_21750"
    ]
}',
    'securityJql' => '
    {
    "jql": "project in (TCP, EV, CB, MCN, SLP, CE) and labels = security-vulnerability and statusCategory != done ORDER BY duedate ASC, key ASC",
	"maxResults" : 1000,
	"fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "updated",
        "parent",
        "issuelinks",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702"
    ]
}',
    'timespentJqlFragment' => '
    "maxResults" : 1000,
	"fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "updated",
        "parent",
        "issuelinks",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_10105",
        "customfield_10400",
        "changelog"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_10105",
        "customfield_10400",
        "changelog"
    ]'
);