<?php
return array(
    'consumerKey' => 'twitchtpm',
    'baseURI' => "https://jira.xarth.tv/rest/api/2/",
    'projects' => "VODPROD, CE, CB, SLP, CPLAT, CESPORTS, CEWP, TCP, AMP, IMP, MAR, ATLAS, AMP, IMP, MAR, ATLAS",
    'jqlFragment' => '{
    "jql": "[[JQL]]",
	"maxResults" : 1000,
	"fields": [
    "names",
    "summary",
    "status",
    "updated",
    "assignee",
    "resolution",
    "issuetype",
    "duedate",
    "parent",
    "issuelinks",
    "labels",
    "priority",
    "project",
    "customfield_13601",
    "components",
    "outwardIssue",
    "fixVersions",
    "timetracking",
    "timeoriginalestimate",
    "customfield_15100",
    "customfield_17202",
    "customfield_13104",
    "customfield_18001",
    "customfield_18201",
    "customfield_17802",
    "customfield_19701",
    "customfield_19702",
    "customfield_20800",
    "customfield_11000",
    "customfield_10105",
    "customfield_10400"
],
	"expand": [
    "names",
    "issuelinks",
    "outwardIssue",
    "inwardIssue",
    "assignee",
    "fields",
    "parent",
    "components",
    "fixVersions",
    "timetracking",
    "timeoriginalestimate",
    "customfield_15100",
    "customfield_17202",
    "customfield_13104",
    "customfield_18001",
    "customfield_18201",
    "customfield_17802",
    "customfield_19701",
    "customfield_19702",
    "customfield_11000",
    "customfield_10105",
    "customfield_10400"
]
}',
    'programJql' => array(
        'source' => "jira",
        'jql' => "project in (VODPROD, CE, CB, SLP, CPLAT, CESPORTS, CEWP, AMP, IMP, MAR, ATLAS, TCP, EV, MCN, SLP, DESKTOP) AND issuetype in (epic, story, \"Project Plan\", initiative) and labels in ([[LABELS]]) and (resolved > -7d or resolution is empty) ORDER BY duedate ASC"),
    'launchedJql' => array(
        'source' => "jira",
        'jql' => "labels in (wpu) AND project in (VODPROD, CE, CB, SLP, CPLAT, CESPORTS, CEWP, AMP, IMP, MAR, ATLAS, TCP, EV, MCN, SLP, DESKTOP) AND duedate  >= -15d and duedate <= 0d ORDER BY duedate  DESC"),
    'roadmapJql' => array(
        'source' => "jira",
        'jql' =>"labels in (roadmap) AND labels not in (wpu, oe) AND project in (VODPROD, CE, CB, SLP, CPLAT, CESPORTS, CEWP, AMP, IMP, MAR, ATLAS, TCP, EV, MCN, SLP, DESKTOP) AND status in (\"Definition [3]\", \"Working Backwards [1 - 2c]\", \"Iteration + Feedback [3, 4a]\", \"Design Review [4B]\", \"Deliverables [5a]\", \"ET Team Peer Review [5b]\", \"ET Team Go/No-go [5c]\") ORDER BY due ASC, status ASC"),
    'securityJql' => array(
        'source' => "jira",
        'jql' => "project in (VODPROD, CE, CB, SLP, CPLAT, CESPORTS, CEWP, AMP, IMP, MAR, ATLAS, TCP, EV, MCN, SLP, DESKTOP) and labels = security-vulnerability and statusCategory != done ORDER BY duedate ASC, key ASC"),
);