<?php
return array(
    'consumerKey' => 'twitchtpm',
    'baseURI' => "https://jira.xarth.tv/rest/api/latest/",
    'projects' => "SLP, CPLAT",
    'fvmilestone' => "\"2020.Q3 TS\", \"Twitch Radio - Milestone 3\"",
    'roadmapLabel' => 'creator-roadmap-spotlight',
    'jqlFragment' => '{
    "jql": "[[JQL]]",
	"maxResults" : 1000,
	"fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "resolution",
        "issuetype",
        "duedate",
        "parent",
        "issuelinks",
        "labels",
        "priority",
        "project",
        "customfield_13601",
        "components",
        "outwardIssue",
        "fixVersions",
        "timetracking",
        "timeoriginalestimate",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_20800",
        "customfield_11000",
        "customfield_10105",
        "customfield_10400"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "components",
        "fixVersions",
        "timetracking",
        "timeoriginalestimate",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_11000",
        "customfield_10105",
        "customfield_10400"
    ]
}',
    'fvStories' => array(
        'source' => "jira",
        'jql' => "fixVersion in ([[FVMILESTONE]]) and issuetype in (task, story) AND project in ([[PROJECT]]) AND statusCategory != Done AND priority in (\"P0 - Urgent\", \"P1 - High\", \"P2 - Normal\") order by project, \"Epic Link\" ASC, sprint asc, resolution desc, status, updated",
        'link' => "https://jira.xarth.tv/issues/?jql="
    )
);