<?php
//generic weekly operation review config that can be used be all teams
return array(
    'consumerKey' => 'twitchtpm',
    'baseURI' => "https://jira.xarth.tv/rest/api/2/",
    'jqlFragment' => '{
    "jql": "[[JQL]]",
	"maxResults" : 1000,
	"fields": [
        "names",
        "summary",
        "status",
        "updated",
        "assignee",
        "epic link",
        "resolution",
        "issuetype",
        "duedate",
        "parent",
        "issuelinks",
        "labels",
        "priority",
        "project",
        "issuelinks",
        "customfield_13601",
        "outwardIssue",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_20800",
        "customfield_21321"
    ],
	"expand": [
        "names",
        "issuelinks",
        "outwardIssue",
        "inwardIssue",
        "assignee",
        "fields",
        "parent",
        "issuelinks",
        "customfield_15100",
        "customfield_17202",
        "customfield_13104",
        "customfield_18001",
        "customfield_18201",
        "customfield_17802",
        "customfield_19701",
        "customfield_19702",
        "customfield_21321"
    ]
}',
    'availabilityPerService' => array(
    ),
    'AWSCosts' => array(
        'source' => "gsheets",
        'sheetId' => "15j3X_rfyObZ1DSKhVELnlIZriIYb6c080MpknMtZUxQ",
        'link' => "https://docs.google.com/spreadsheets/d/15j3X_rfyObZ1DSKhVELnlIZriIYb6c080MpknMtZUxQ/edit#gid=267322130",
//        'sheetRange' => "'Q1 Update: 2019 AWS Spend Overview'!A26:CH43"
    ),
    'securityExpectations' => array(
        'source' => "gsheets",
        'sheetId' => "1OAO0xceITLdLtlav2HoxdHXOIxkFwXB3A1-k6kE22qo",
        'link' => "https://docs.google.com/spreadsheets/d/1OAO0xceITLdLtlav2HoxdHXOIxkFwXB3A1-k6kE22qo/edit#gid=733569707"
    ),
    'availabilityExpectations' => array(
        'source' => "gsheets",
        'sheetId' => "1B_jYTcxDmZQ_tkSITTZMLx07Nw_SNsoiXswpB4WicXk",
        'link' => "https://docs.google.com/spreadsheets/d/1B_jYTcxDmZQ_tkSITTZMLx07Nw_SNsoiXswpB4WicXk/edit#gid=598416105", //just for viewing
        'KPIsheetId' => "1Q0iwm4JgG9AOgl9_TkK7YgDmzFcCcbXhppOJp_aCmg8",
        'KPIsheetRange' => "'Avail - Expectations 2019'!A7:Q68",
        'KPIlink' => "https://docs.google.com/spreadsheets/d/1Q0iwm4JgG9AOgl9_TkK7YgDmzFcCcbXhppOJp_aCmg8/edit#gid=108601309" //this sheet is used for the data load
    ),
    'CWT' => array(
        'source' => "latency"
    ),
    'unclassifiedJira' => array(
        'source' => "jira",
        'jql' => "(issuetype in (Bug) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND (Severity is EMPTY and (\"Found In\" is EMPTY or \"Found In\" =  Production) and statusCategory != Done) AND project in ([[PROJECT]]) ORDER BY cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    'sev3PlusJira' => array(
        'source' => "jira",
        'jql' => "((issuetype in (Bug) AND \"Found In\" = Production) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND Severity in (Sev-3, Sev-2.5, Sev-2, Sev-1) AND statusCategory != Done AND status != Completed AND status != Cancelled AND project in ([[PROJECT]]) ORDER BY cf[13601] ASC, cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    'ooslaJira' => array(
        'source' => "jira",
        'jql' => "(issuetype in (Bug) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND (\"Found In\" = Production AND (Severity = Sev-3 AND \"Issue Age\" > 30 OR Severity = Sev-2.5 AND \"Issue Age\" > 2 OR Severity = Sev-2 AND \"Issue Age\" > 1 OR Severity = Sev-1 AND \"Issue Age\" > 0) AND statusCategory != Done OR labels = post-mortem AND status not in (closed, done, rejected, resolved, Completed, Cancelled) AND (duedate <= endOfDay() OR due is EMPTY AND created <= startOfDay(-30d))) AND project in ([[PROJECT]]) ORDER BY cf[13601] ASC, cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    'availabilityRemediation' => array(
        'source' => "jira",
        'jql' => "(issuetype in (Bug) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND labels in (post-mortem, Post-Mortem) AND statusCategory != Done AND project in ([[PROJECT]]) ORDER BY cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    'securityVulnerabilities' => array(
        'source' => "jira",
        'jql' => "(issuetype in (Bug) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND labels = security-vulnerability AND statusCategory != Done AND project in ([[PROJECT]]) ORDER BY cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    'securityRemediation' => array(
        'source' => "jira",
        'jql' => "(issuetype in (Bug) OR project in (\"Security Incident Post Mortems\") OR labels in (security-vulnerability, post-mortem, Post-Mortem) OR project = Incident) AND issueFunction in issuesInEpics(\"project = RIP AND issuetype = Epic AND statusCategory != Done\") AND statusCategory != Done AND project in ([[PROJECT]])",
        'link' => "https://jira.xarth.tv/issues/?jql="
    ),
    // 'incidentsOwned' => array(
    //     'source' => "jira",
    //     'jql' => "project = Incident AND resolutiondate > startOfDay(-8d) AND component is EMPTY AND (assignee in ([[TEAM]]) OR reporter in ([[TEAM]]))",
    //     'link' => "https://jira.xarth.tv/issues/?jql="
    // ),
    // 'incidentsOwned' => array(
    //     'source' => "jira",
    //     'jql' => "project = Incident AND resolutiondate > startOfDay(-8d) AND component is EMPTY AND (assignee in ([[TEAM]]) OR reporter in ([[TEAM]]) OR \"Services Impacted\" is not EMPTY)",
    //     'link' => "https://jira.xarth.tv/issues/?jql="
    // )
    'incidentsOwned' => array(
        'source' => "jira",
        'jql' => "project = Incident AND resolutiondate > startOfDay(-8d) ORDER BY cf[13601] ASC, cf[20800] DESC",
        'link' => "https://jira.xarth.tv/issues/?jql="
    )
);