<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>Central Science</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;Central Science - Program Update</span>
</div>
<br/>
<br/>
@if ($active)
<div class="block">
    <div class="header">Research in Progress</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 10px;">Project</th>
            <th style="min-width: 10px;">Project Lead</th>
            <th style="min-width: 10px;">Team</th>
            <th style="min-width: 80px;">Details</th>
            <th style="width:55px">Days in Status</th>
            {{--<th style="width:78px">Next Step Target</th>--}}
            <th style="width:50px">Target</th>
            <th style="min-width: 10px;">Status Notes</th>
        </tr>
        @php
            $statusSection = " ";
        @endphp
        @foreach($active as $issue)
            @if (isset($issue->fields->status) && $statusSection != $issue->fields->status->name)
                <tr>
                    <td colspan="7" style="text-align: left; background-color: #eeeeee;"><b> Projects in {{$issue->fields->status->name}} </b>
                        @php
                            $statusSection = $issue->fields->status->name;
                        @endphp
                    </td>
                </tr>
            @endif
            <tr>
                {{--Project Name--}}
                @php
                    $isBigRock = in_array("big-rock", $issue->fields->labels);//loose comparison
                @endphp
                @if($isBigRock)
                    <td bgcolor="E9DEFF"><strong><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></strong></td>
                @else
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @endif
                {{--STL--}}
                {{-- @php
                    $stlOrPoc = Helpers::returnSTL($issue->key, $stls);
                    if($stlOrPoc == "<i>TBD</i>")
                        $stlOrPoc = $issue->fields->assignee->displayName;
                @endphp--}}
                {{--Prj Lead--}}
                <td nowrap>
                @if(isset($issue->fields->assignee->displayName))
                    <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  \App\Http\Controllers\CentSci::getShortName($issue->fields->assignee->displayName) }}</a>
                @else
                    <i>TBD</i>
                @endif
                </td>
                {{--PM--}}
                <td nowrap>
                    @if (isset($issue->fields->customfield_21821->value))
                        {{$issue->fields->customfield_21821->value}}
                    @endif
                    {{--@if(isset($issue->fields->customfield_18003->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18003->emailAddress }}">{{  \App\Http\Controllers\CentSci::getShortName($issue->fields->customfield_18003->displayName) }}</a>
                    @else
                        <i>TBD</i>
                    @endif--}}
                </td>
                {{--}}@if (isset($issue->fields->assignee))
                    <td>
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  $issue->fields->assignee->displayName }}</a>
                    </td>
                @else
                    <td><i>None</i></td>
                @endif--}}

                {{--Details section--}}
                <td nowrap>
                    {{--Emails--}}
                    @if (isset($issue->fields->customfield_21635))
                        <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @elseif (isset($issue->fields->assignee))
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @endif
                    {{--Slack--}}
                    @if (isset($issue->fields->customfield_13800))
                        <a href="slack://channel?team=T0266V6GF&id={{ $issue->fields->customfield_13800 }}"><img class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>
                    @else
                        {!! Helpers::returnSlackProject($issue->key, $stls) !!}
                    @endif
                    {{--Product Spec--}}
                    @if (isset($issue->fields->customfield_18201))
                        <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                    @endif
                    {{--Tech Spec--}}
                    @if (isset($issue->fields->customfield_18401))
                        <a href="{{$issue->fields->customfield_18401}}"><img class="icon" src="https://image.ibb.co/cPKF2U/tech_spec_icon.png"/></a>
                    @endif
                </td>

                <td>
                    {{ \App\Http\Controllers\CentSci::getTimeInStatus($issue->fields->customfield_20800, $issue->changelog) }} days
                </td>
                <!--Project Process Next Step (date), if there's no due date yet-->
                {{--
                @if (isset($issue->fields->duedate)) <td><i>N/A</i></td>
                @elseif (isset($issue->fields->customfield_21750))
                    @if(Carbon\Carbon::parse($issue->fields->customfield_21750)->isPast() && !Carbon\Carbon::parse($issue->fields->customfield_21750)->isToday())
                        <td style="color:#ff0000">{{ Carbon\Carbon::parse($issue->fields->customfield_21750)->format('D, M d') }}</td>
                    @else
                        <td>{{ Carbon\Carbon::parse($issue->fields->customfield_21750)->format('D, M d') }}</td>
                    @endif
                @else <td><i>TBD</i></td>
                @endif
                --}}
                <!--Due Date-->
                @if (isset($issue->fields->duedate))
                    <td>
                        @if (isset($issue->fields->customfield_17202))
                            @if($issue->fields->customfield_17202->value == "Green")
                                <span class="dot green"></span>
                            @elseif($issue->fields->customfield_17202->value == "Yellow")
                                <span class="dot yellow"></span>
                            @elseif($issue->fields->customfield_17202->value == "Red")
                                <span class="dot red"></span>
                            @elseif($issue->fields->customfield_17202->value == "On Hold")
                                <span class="dot yellow"></span>
                            @elseif($issue->fields->customfield_17202->value == "In Planning")
                                <span class="dot aqua"></span>
                            @else
                                <span class="dot green"></span>
                            @endif
                        @else
                            <span class="dot gray"></span>
                        @endif
                        {{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j') }}
                    </td>
                @else <td><i>TBD</i></td>
                @endif
                <!-- Risks & Notes - VE-only field-->
                <td>
                    @if(isset($issue->fields->customfield_17802))
                        {{$issue->fields->customfield_17802}}
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
</div>
<br/>
@endif
<br/>
<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>