<!DOCTYPE html>
<html>
<head lang="en">
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-124899349-1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'UA-124899349-1');
    </script>
    <meta name="x-apple-disable-message-reformating" charset="UTF-8"/>
    <title>{{ $projectName }} Program Update</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .bigrock { background-color: #E9DEFE; color: #000000; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;{{ $projectName }}
        ({{ Carbon\Carbon::today()->startOfWeek()->format('M d') }}
        - {{ Carbon\Carbon::today()->endOfWeek()->format('M d') }})</span>
</div>
@if (strtoupper($wpuDigest) != "SKIP")
<div class="block">
    <div class="header">Notes</div>
    {!! $wpuDigest !!}
</div>
<br/>
@endif
@if (count($red) > 0)
    <div class="block">
        <div class="header">Programs in RED</div>
        <table class="breakdown">
            <tr>
                <th style="min-width: 50px;" nowrap>Target</th>
                <th style="min-width: 130px;">Project</th>
                <th style="min-width: 30px;">STL</th>
                <th style="min-width: 65px;" nowrap>Details</th>
                <th style="min-width: 155px;">Risks &amp; Notes</th>
            </tr>
            @php
                $weekNumber = 0;
            @endphp
            @foreach($red as $issue)
                @php
                    if(in_array("big-rock", $issue->fields->labels)) {
                        $rowcolor = "#E9DEFE";
                    } else {
                        $rowcolor = "#FFFFFF";
                    }
                @endphp
                <tr style="background-color: {{ $rowcolor }}">
                    <td nowrap><span class="dot red"></span> 
                        @if (isset($issue->fields->duedate))
                                {{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j') }}
                                @if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)
                                    <br/>
                                    <strike style="margin-left: 13px;">{{ Carbon\Carbon::parse($issue->fields->customfield_18001)->format('n/j') }}</strike>
                                @endif
                        </td>
                        @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                            &nbsp;TBD</td>
                        @else
                            &nbsp;TBD</td>
                        @endif

                        <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>


                        {{--STL--}}
                        <td style="min-width: 70px; white-space: nowrap;" nowrap>{!! Helpers::returnSTL($issue->key, $stls) !!}</td>

                        {{--Details section--}}
                        <td nowrap>
                            {{--Emails--}}
                            @if (isset($issue->fields->customfield_21635))
                                <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                            @elseif (isset($issue->fields->assignee))
                                <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                            @endif
                            {{--Slack--}}
                            @if (isset($issue->fields->customfield_13800))
                                <a href="https://twitch.slack.com/app_redirect?team=T0266V6GF&channel={{ $issue->fields->customfield_13800 }}"><img class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>
                            @else
                                {!! Helpers::returnSlackProject($issue->key, $stls) !!}
                            @endif
                            {{--Docs--}}
                            @if (isset($issue->fields->customfield_18201))
                                <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                            @endif
                        </td>

                        @if (isset($issue->fields->customfield_17802))
                            <td style="min-width: 120px">{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}
                        @else
                            <td>
                        @endif
                                <span class="note">({{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }})</span></td>
                </tr>
            @endforeach
        </table>
    </div>
    <br/>
@endif
@if (count($launched) > 0)
<div class="block">
    <div class="header">Launched since the Last Report</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 50px;" nowrap>Launched</th>
            <th style="min-width: 130px;">Project</th>
            <th style="min-width: 30px;">STL</th>
            <th style="min-width: 65px;" nowrap>Details</th>
            <th style="min-width: 155px;">Risks &amp; Notes</th>
        </tr>
        @foreach($launched as $issue)
            @php
                if(in_array("big-rock", $issue->fields->labels)) {
                    $rowcolor = "#E9DEFE";
                } else {
                    $rowcolor = "#FFFFFF";
                }
            @endphp
            <tr style="background-color: {{ $rowcolor }}">
                <td>{{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j') }}</td>
                <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>

                {{--STL--}}
                <td style="min-width: 70px; white-space: nowrap;" nowrap>{!! Helpers::returnSTL($issue->key, $stls) !!}</td>

                {{--Details section--}}
                <td nowrap width="65">
                    {{--Emails--}}
                    @if (isset($issue->fields->customfield_21635))
                        <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @elseif (isset($issue->fields->assignee))
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @endif
                    {{--Slack--}}
                    @if (isset($issue->fields->customfield_13800))
                        <a href="https://twitch.slack.com/app_redirect?team=T0266V6GF&channel={{ $issue->fields->customfield_13800 }}"><img class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>
                    @else
                        {!! Helpers::returnSlackProject($issue->key, $stls) !!}
                    @endif
                    {{--Docs--}}
                    @if (isset($issue->fields->customfield_18201))
                        <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                    @endif
                </td>

                @if (isset($issue->fields->customfield_17802))
                    <td style="min-width: 120px">{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}
                @else
                    <td>
                        @endif
                        {{--Updated Data from JIRA--}}
                        <span class="note">({{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }})</span></td>
            </tr>
        @endforeach
    </table>
</div>
@endif
<br/>
<div class="block">
    <div class="header">Program Updates</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 50px;" nowrap>Target</th>
            <th style="min-width: 130px;">Project</th>
            <th style="min-width: 30px;">STL</th>
            <th style="min-width: 65px;" nowrap>Details</th>
            <th style="min-width: 155px;">Risks &amp; Notes</th>
        </tr>
        @php
            $weekNumber = 0;
        @endphp
        @foreach($issues as $issue)
            @if (isset($issue->fields->duedate) && $weekNumber != Carbon\Carbon::parse($issue->fields->duedate)->weekOfYear)
                <tr>
                    <td colspan="5" style="text-align: left; background-color: #eeeeee;">Week
                        of {{ Carbon\Carbon::parse($issue->fields->duedate)->startOfWeek()->format('M j') }}
                        - {{ Carbon\Carbon::parse($issue->fields->duedate)->endOfWeek()->format('M j') }}
                        @php
                            $weekNumber = Carbon\Carbon::parse($issue->fields->duedate)->weekOfYear;
                        @endphp
                        @if ($weekNumber == Carbon\Carbon::today()->weekOfYear)
                            <b>(Launching this week)</b>
                        @endif
                    </td>
                </tr>
            @endif
            @php
            if(in_array("big-rock", $issue->fields->labels)) {
                $rowcolor = "#E9DEFE";
            } else {
                $rowcolor = "#FFFFFF";
            }
            @endphp
            <tr style="background-color: {{ $rowcolor }}">
                <td nowrap>
                @if (isset($issue->fields->customfield_17202))
                    @if($issue->fields->customfield_17202->value == "Green")
                        <span class="dot green"></span>
                    @elseif($issue->fields->customfield_17202->value == "Yellow")
                        <span class="dot yellow"></span>
                    @elseif($issue->fields->customfield_17202->value == "Red")
                        <span class="dot red"></span>
                    @elseif($issue->fields->customfield_17202->value == "On Hold")
                        <span class="dot yellow"></span>
                    @elseif($issue->fields->customfield_17202->value == "In Planning")
                        <span class="dot aqua"></span>
                    @else
                        <span class="dot green"></span>
                    @endif
                @else
                    <span class="dot green"></span>
                @endif

                         @if (isset($issue->fields->duedate))
                            {{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j') }}
                            @if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)
                            <br/><strike style="margin-left: 13px;">{{ Carbon\Carbon::parse($issue->fields->customfield_18001)->format('n/j') }}</strike>
                            @endif
                        @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                        TBD</td>
                    @else
                        TBD</td>
                    @endif

                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>

                    {{--STL--}}
                    <td style="min-width: 70px; white-space: nowrap;" nowrap>{!! Helpers::returnSTL($issue->key, $stls) !!}</td>

                    {{--Details section--}}
                    <td nowrap>
                        {{--Emails--}}
                        @if (isset($issue->fields->customfield_21635))
                            {{--data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAAQCAYAAAAbBi9cAAABCklEQVQ4ja3TsUqCYRQG4Kevv63c2pIW76ALaAja2hPHFpU2J/fAya20uYguoCWiLqE5kghCp9p0lwZP9CMVxu8LZ/jOed/3HD7OYUlYOdq9PEWtoM9VhjpWCxrVE8q4KjINyglVNLGP0T8MRqFpoprQxSOG2EZ/AZN+cIeh7SZMUMETTqLDHt5/MHiPWjO4T6GdJExzxDY+UIqOnVytE7lScNq52jT7Y/x1nOE+3s+R+xEpIt91E2O8YoC1iEHkxsHJT5sybOAFB0HuoZEj3c41fzD77GNc4AaVhBZ2zPbpbc7kNzSCWw5tK+E6prjD1gImX9gKTQ/XmdkuFDmRGg4znFvC0RbUf+MTCyY4oWomXv0AAAAASUVORK5CYII=--}}
                            <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                        @elseif (isset($issue->fields->assignee))
                            <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                        @endif
                        {{--Slack--}}
                        @if (isset($issue->fields->customfield_13800))
                            <a href="https://twitch.slack.com/app_redirect?team=T0266V6GF&channel={{ $issue->fields->customfield_13800 }}"><img class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>
                        @else
                            {!! Helpers::returnSlackProject($issue->key, $stls) !!}
                        @endif
                        {{--Docs--}}
                        @if (isset($issue->fields->customfield_18201))
                            {{--data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAgElEQVQ4je3TsQnCYBCG4cef3yjW7mKZDbKEG1gEV9DCJdwgw4lGCxtDUFDOBKz8qjuO9+NtbrIujyVqLHATS8YJ+4wdVkHwNcuEy0AYzhlttx2aKkRtqqYb2/zmEM5TwQADf4NfGXwqHm2QUHxN9SkSZiMK5hlb/Ttfg+DU453vgfsjQvqemY4AAAAASUVORK5CYII=--}}
                            <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                        @endif
                    </td>

                    @if (isset($issue->fields->customfield_17802))
                        <td style="min-width: 120px">{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}
                    @else
                        <td>
                    @endif
                        {{--Updated Data from JIRA--}}
                        <span class="note">({{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }})</span></td>
            </tr>
        @endforeach
    </table>
    <div>
        <span class="regular" style="font-weight: bold;">Legend:</span>
        <span class="legend"><span class="dot green"></span> On Track</span>
        <span class="legend"><span class="dot yellow"></span> Known Risks</span>
        <span class="legend"><span class="dot red"></span> Blocked / At-Risk</span>
        <span class="legend"><span class="dot aqua"></span> In Planning</span>
        <b>/</b> <span class="bigrock legend">Big Rock</span>
    </div>
</div>
<br/>
<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>