<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }} Program Update</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; font-family: helvetica, tahoma, arial; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .sub-header { font-size: 10pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #eeeeee; color: #5C459D; vertical-align: middle;
            font-weight: bold; }
        .info { margin: 12px; }
        .strike, .strike a:link, .strike a:visited { text-decoration: line-through; color: #AEAEAE; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a:visited { color: #5C459D; }


        pre, .regular, .summary p, p, .summary { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 1px; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        ul li ul { margin-left: 8px; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }

        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .bigrock { background-color: #E9DEFE; color: #000000; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }

        #gantt div div svg g text {
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
        }
    </style>
    <!--Load the AJAX API-->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
    <!-- Required to convert named colors to RGB -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/canvg/1.4/rgbcolor.min.js"></script>
    <!-- Optional if you want blur -->
    <script src="https://cdn.jsdelivr.net/npm/stackblur-canvas@^1/dist/stackblur.min.js"></script>
    <!-- Main canvg code -->
    <script src="https://cdn.jsdelivr.net/npm/canvg/dist/browser/canvg.min.js"></script>
    <script type="text/javascript">
        //custom error handling when not enough columns to draw the charts
        function errorHandler(errorMessage) {
            //curiosity, check out the error in the console
            console.log(errorMessage);

            //simply remove the error, the user never see it
            google.visualization.errors.removeError(errorMessage.id);
        }

        // Load the Visualization API and the piechart package.
        google.charts.load('current', {'packages':['corechart']});

        // Set a callback to run when the Google Visualization API is loaded.
        google.charts.setOnLoadCallback(drawChart);


        function drawChart() {
                    @php
                        $i = 1;
                    @endphp
                    @foreach($burndownGraphs as $jiraproject => $graph)

                    @php
                        if(Config::get("$project.$subproject.burndowns.$jiraproject.chartWidth") == null) {
                            $chartWidth = 480;
                        } else {
                            $chartWidth = Config::get("$project.$subproject.burndowns.$jiraproject.chartWidth");
                        }
                         if(Config::get("$project.$subproject.burndowns.$jiraproject.chartAreaWidth") == null) {
                            $chartAreaWidth = 480;
                        } else {
                            $chartAreaWidth = Config::get("$project.$subproject.burndowns.$jiraproject.chartAreaWidth");
                        }
                    @endphp
            var jsonData{{ $loop->iteration }} = $.ajax({
                    url: "/twitch/fvburndown/{{ $project }}/{{ $subproject }}/{{ $jiraproject }}",
                    dataType: "json",
                    async: false
                }).responseText;

            var options = {
                title: "{{ $graph["title"] }}",
                titlePosition: 'out',
                titleTextStyle: {
                    color: "#000000",
                    fontName: "Helvetica, Tahoma, Arial",
                    fontSize: 12,
                    bold: true,
                    italic: false
                },
                chartArea: {
                    width: {{ $chartAreaWidth }},
                    height: 200,
                },
                width: {{ $chartWidth }},
                height: 300,
                axisTitlesPosition: 'out',
                vAxis: {
                    title: "{{ $graph["vaxisTitle"] }}",
                    format: 'short',
                    minValue: 0,
                    gridlines: {count: 5},
                    textStyle: {
                        fontName: "Helvetica, Tahoma, Arial",
                        color: '#000000',
                        fontSize: 9,
                        bold: false,
                        italic: false
                    }
                },
                hAxis: {
                    title: '{{ $graph["haxisTitle"] }}',
                    slantedTextAngle: 90,
                    {{--minValue: new Date({{ Carbon\Carbon::today()->subMonth(6)->format('Y') }}, {{ Carbon\Carbon::today()->subMonth(6)->format('m') }}, 1),--}}
                            {{--maxValue: new Date({{ Carbon\Carbon::today()->format('Y') }}, {{ Carbon\Carbon::today()->format('m') }}, 1),--}}
                    textStyle: {
                        fontName: "Helvetica, Tahoma, Arial",
                        color: '#000000',
                        fontSize: 9,
                        bold: false,
                        italic: false
                    },
                    format: 'M/d',
                    gridlines: {count: 20}
                },
                format: 'EEE, MMM d',
                isStacked: true,
                bar: {groupWidth: "60%"},
                legend: {
                    position: 'top',
                    maxLines: 1,
                    textStyle: {
                        fontSize: 10,
                        bold: false
                    }
                },
                colors: [
                    "#5B469D",
                    "#DC3812"
                ],
                series: {
                    2: {
                        type: 'line',
                        color: '#ffcc33',
                        lineDashStyle: [4, 3],
                        lineWidth: 2
                    }
                }
            };

            // Create our data table out of JSON data loaded from server.
            var data{{ $loop->iteration }} = new google.visualization.DataTable(jsonData{{ $loop->iteration }});

            // Instantiate and draw our chart, passing in some options.
            var chart{{ $loop->iteration }} = new google.visualization.ColumnChart(document.getElementById('chart_div{{ $loop->iteration }}'));

            // Render as image for email or SVG for webpage display with mouseovers
            @if (app('request')->input('graph') == "image" or $graphJS == "image")
            google.visualization.events.addListener(chart{{ $loop->iteration }}, 'ready', function () {
                chart_div{{$i}}.innerHTML = '<a href="{{ $graph["link"] }}" target="new"><img src="' + chart{{ $loop->iteration }}.getImageURI() + '"></a>';
            });
            @endif

            //attach the error handler here, before draw()
            google.visualization.events.addListener(chart{{ $loop->iteration }}, 'error', errorHandler);
            chart{{ $loop->iteration }}.draw(data{{ $loop->iteration }}, options);
            @php
                $i++;
            @endphp
            @endforeach
        }
    </script>
    @if($timeline != null)
    <script type="text/javascript">
        google.charts.load('current', {
            callback: drawGantt,
            packages: ['gantt']
        });

        function daysToMilliseconds(days) {
            return days * 24 * 60 * 60 * 1000;
        }

        function drawGantt() {

            var data = new google.visualization.DataTable();
            data.addColumn('string', 'Task ID');
            data.addColumn('string', 'Task Name');
            data.addColumn('string', 'Resource');
            data.addColumn('date', 'Start Date');
            data.addColumn('date', 'End Date');
            data.addColumn('number', 'Duration');
            data.addColumn('number', 'Percent Complete');
            data.addColumn('string', 'Dependencies');

            //https://developers.google.com/chart/interactive/docs/gallery/ganttchart
            //https://matthewelsom.com/blog/styling-google-gantt-chart-with-css.html
            //Task ID, Task Name, Resource ID (optional), Start, End Duration (in milliseconds), Percent Complete, Dependencies
            data.addRows([
                {!! $timeline["gantt"] !!}
            ]);

            var options = {
                height: 150,
                width: 900,
                gantt: {
                    criticalPathEnabled: false, // Critical path arrows will be the same as other arrows.
                    arrow: {
                        angle: 100,
                        width: 3,
                        color: '#5B469D',
                        radius: 0
                    },
                    trackHeight: 30,
                    barHeight: 20,
                    labelStyle: {
                        fontName: "Helvetica, Tahoma, Arial",
                        fontSize: 11,
                        color: "#5B469D"
                    },
                    palette: [
                        {
                            "color": "#5B469D",
                            "dark": "#5B469D",
                            "light": "#5B469D"
                        },
                        {
                            "color": "#ff9933",
                            "dark": "#ff9933",
                            "light": "#ff9933"
                        },
                        {
                            "color": "#DC3812",
                            "dark": "#DC3812",
                            "light": "#DC3812"
                        }
                    ]
                },
                hAxis: {
                    format: 'M/d',
                    gridlines: { count: 10 }
                },
            };

            var chart = new google.visualization.Gantt(document.getElementById('gantt'));

            // Wait for the chart to finish drawing before calling the getImageURI() method.
            google.visualization.events.addListener(chart, 'ready', function() {
                var svg = document.getElementsByTagName("svg")[0];
                console.log(svg);
                var output = document.createElement('canvas');
                canvg(output, new XMLSerializer().serializeToString(svg));
                @if (app('request')->input('graph') == "image" or $graphJS == "image")
                    var gantt = document.getElementById("gantt");
                    gantt.appendChild(output);
                    gantt.removeChild(gantt.childNodes[0]);
                @endif
            });

            chart.draw(data, options);
        }
    </script>
    @endif
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;{{ $projectName }}
        ({{ Carbon\Carbon::today()->startOfWeek()->format('M d') }}
        - {{ Carbon\Carbon::today()->endOfWeek()->format('M d') }})</span>
</div>
<br/>
<div class="block">
    <div class="header">Summary</div>
    <div class="summary">{!! $summary !!}</div>

    @if($timeline != null)
    <div class="block sub-header">Timeline</div>
    @if (Config::get("$project.$subproject.projectinfo.timeline.blurbText") != null)
        {!! Config::get("$project.$subproject.projectinfo.timeline.blurbText") !!}
    @endif
    <div class="block" style="margin: 10px 10px;">
        <div id="gantt"></div>
    </div>
    @endif

    @if($burndownGraphs)
    <div class="block sub-header">Burndown</div>
    <div class="block" style="margin: 10px 10px;">
        @for($j = 1; $j < $i; $j++)
            <div style="float: left;" id="chart_div{{$j}}"></div>
        @endfor
    </div>
    @endif

    {{--2 column dependency tracking info--}}
    <div class="block sub-header">Document Links</div>
    <ul class="info" style="float: left">
        @foreach($documents as $name => $link)
            <li><a href="{{ $link }}" target="new">{{  Illuminate\Support\Str::title($name) }}</a></li>
            @break ($loop->iteration > ceil($loop->count/2) - 1)
        @endforeach
    </ul>
    <ul class="info" style="float: left">
        @foreach($documents as $name => $link)
            @if($loop->iteration > ceil($loop->count/2))
                <li><a href="{{ $link }}" target="new">{{  Illuminate\Support\Str::title($name) }}</a></li>
            @endif
        @endforeach
    </ul>
</div>
<br/>
@if (count($dependencies) > 0)
<div class="block">
    <div class="header">Dependencies</div>
    @if (Config::get("$project.$subproject.projectinfo.dependency.blurbText") != null)
        {!! Config::get("$project.$subproject.projectinfo.dependency.blurbText") !!}
    @endif
    @if (!isset($dependencies) || count($dependencies[1]) < 4)
        <p style="text-align: center; font-weight: bold">No dependencies remaining</p>
    @else
        <table class="breakdown">
            @foreach($dependencies as $dependency)
                @if(
                    Config::get("$project.$subproject.projectinfo.dependency.excludeFromSheet") &&
                    !in_array($dependency[0], Config::get("$project.$subproject.projectinfo.dependency.excludeFromSheet")) &&
                    $dependency[1] != "#N/A"
                    )
                    @if($loop->first)
                        <tr>
                            @foreach($dependency as $item)
                                <th>{{ $item }}</th>
                                @php
                                    $numOfColumns = count($dependency); //max number of columns
                                @endphp
                            @endforeach
                        </tr>
                    @else
                        <tr>
                            @foreach($dependency as $item)
                                @php
                                    //PHP_EOL not working in windows
                                    if(strcasecmp(substr(PHP_OS, 0, 3), 'WIN') == 0){
                                        $itemAry = explode("\n", trim($item));
                                    } else {
                                        $itemAry = explode(PHP_EOL, trim($item));
                                    }
                                @endphp
                                <td>
                                    @if(count($itemAry) > 0)
                                        @foreach($itemAry as $i)
                                            @if ($i == "TBD")
                                                <i>{{ $i }}</i><br />
                                            @else
                                                {!! Helpers::convertStringtoLinks($i) !!}<br />
                                            @endif
                                        @endforeach
                                    @else
                                        {!! nl2br(Helpers::convertStringtoLinks($item)) !!}
                                    @endif
                                </td>
                                @if($loop->last && $loop->count < $numOfColumns)
                                    <td></td>
                                @endif
                            @endforeach
                        </tr>
                    @endif
                @endif
            @endforeach
        </table>
    @endif
</div>
@endif
<br />
<div class="block">
    <div class="header">{{ \Illuminate\Support\Str::title(preg_replace('/"/m', "", stripslashes(Config::get("$project.$subproject.jira.fvmilestone")))) }} Milestone Updates</div>
    <table class="breakdown">
        @php
            $currentEpic = "";
            $currentFV = "";
            $n = 1;
            $reportCols = \Illuminate\Support\Facades\Config::get("$project.$subproject.projectinfo.reportColumns");
            $divider = \Illuminate\Support\Facades\Config::get("$project.$subproject.projectinfo.reportDivider");
            if($reportCols != null) {
                $colSpan = count($reportCols);
            } else {
                $colSpan = 9;
            }
        @endphp

        <tr>
            @if(in_array("type", $reportCols))
                <th>T</th>
            @endif
            @if(in_array("priority", $reportCols))
                <th>Pri</th>
            @endif
            @if(in_array("summary", $reportCols))
                <th>Summary</th>
            @endif
            @if(in_array("versions", $reportCols))
                <th>Fix Versions</th>
            @endif
            @if(in_array("sprint", $reportCols))
                <th width="100">Sprint</th>
            @endif
            @if(in_array("labels", $reportCols))
                <th>Labels</th>
            @endif
            @if(in_array("components", $reportCols))
                <th>Components</th>
            @endif
            @if(in_array("status", $reportCols))
                <th>Status</th>
            @endif
            @if(in_array("estimate", $reportCols))
                <th>Estimate</th>
            @endif
        </tr>

        @foreach ($inDev as $issue)
            @if ($divider == "versions")
                {{--Create Fix Version Header Rows to make it easier to read, one-to-many for Fix Versions but just use the first one--}}
                @if(isset($issue->fields->fixVersions[0]) && isset($issue->fields->fixVersions[0]->id) && $currentFV != $issue->fields->fixVersions[0]->id)
                    <tr>
                        <td colspan="{{ $colSpan }}" style="background-color: #d2cae8;"><a style="font-weight: bold;" href="https://jira.xarth.tv/issues/?jql=fixVersion%3D{{ $issue->fields->fixVersions[0]->id }}">Fix Version: {{ $issue->fields->fixVersions[0]->name }}</a></td>
                    </tr>
                    @php
                        $currentFV = $issue->fields->fixVersions[0]->id;
                        $n = 1;
                    @endphp
                @elseif ($issue->fields->fixVersions == null && $currentFV != $issue->fields->fixVersions)
                    <tr>
                        <td colspan="{{ $colSpan }}" style="background-color: #d2cae8;"><b>No Fix Version<b/></td>
                    </tr>
                    @php
                        $currentFV = null;
                        $n = 1;
                    @endphp
                @endif
            @else
                {{--Create Epic Rows to make it easier to read, Epic Link field $issue->fields->customfield_11000 --}}
                @if($currentEpic != $issue->fields->customfield_11000 && $issue->fields->customfield_11000 != null)
                    @php
                        if($issue->fields->customfield_11000 != null) {
                            $epic = \App\Http\Controllers\GenericProject::getOneIssue($project, $subproject, $issue->fields->customfield_11000);
                        }
                    @endphp
                    <tr>
                        @if(in_array("type", $reportCols))
                            <td style="background-color: #d2cae8;"><img height=16 width=16 src="{{ Jira::returnIssuetypeImagePath($epic->issuetype->name) }}"></td>
                        @endif
                        @if(in_array("summary", $reportCols))
                            <td colspan="{{ $colSpan }}" style="background-color: #d2cae8;"><a style="font-weight: bold;" href="https://jira.twitch.com/browse/{{ $issue->fields->customfield_11000 }}">[{{ $epic->project->key }}] {{ $epic->summary }}</a></td>
                        @endif
                    </tr>
                    @php
                        $currentEpic = $issue->fields->customfield_11000;
                        $n = 1;
                    @endphp
                @elseif ($issue->fields->customfield_11000 == null && $currentEpic != $issue->fields->customfield_11000)
                    <tr>
                        @if(in_array("type", $reportCols))
                            <td style="background-color: #d2cae8;"><img height=16 width=16 src="{{ Jira::returnIssuetypeImagePath($epic->issuetype->name) }}"></td>
                        @endif
                        @if(in_array("summary", $reportCols))
                            <td colspan="{{ $colSpan }}" style="background-color: #d2cae8;"><b>[{{ $issue->fields->project->key }}] No Epic<b/></td>
                        @endif
                    </tr>
                    @php
                        $currentEpic = null;
                        $n = 1;
                    @endphp
                @endif
            @endif

            @php
                $fvAry = array();
                if(isset($issue->fields->fixVersions) && count($issue->fields->fixVersions) > 0) {
                    foreach($issue->fields->fixVersions as $fv) {
                        $fvAry[$fv->id] = $fv->name;
                    }
                } else {
                    $fvAry = array();
                }

                if($issue->fields->status->name == "Done" OR $issue->fields->status->name == "Closed") {
                    $statusStyle = "class=strike";
                } else {
                    $statusStyle = null;
                }

                if(isset($issue->fields->customfield_10400)) {
                    $sprintInfoAry = explode(",", end($issue->fields->customfield_10400));
                } else {
                    $sprintInfoAry = array();
                }
            @endphp
            <tr>

                {{--issue type image--}}
                @if(in_array("type", $reportCols))
                    <td><img height=16 width=16 src="{{ Jira::returnIssuetypeImagePath($issue->fields->issuetype->name) }}"></td>
                @endif
                {{--priority--}}
                @if(in_array("priority", $reportCols))
                    <td {{ $statusStyle }}>{{ \Illuminate\Support\Str::words($issue->fields->priority->name, 1, "") }}</td>
                @endif
                {{--summary--}}
                @if(in_array("summary", $reportCols))
                    <td {{ $statusStyle }}>{{ $n }}. <a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @endif
                {{--versions--}}
                @if(in_array("versions", $reportCols))
                    @if(count($fvAry) > 0)
                        <td {{ $statusStyle }}>
                        @foreach($fvAry as $id => $fv)
                            <a href="https://jira.xarth.tv/issues/?jql=fixVersion%3D{{ $id }}" target="new">{{ $fv }}</a><br />
                        @endforeach
                        </td>
                    @else
                        <td {{ $statusStyle }}><i>TBD</i></td>
                    @endif
                @endif
                {{--sprint--}}
                @if(in_array("sprint", $reportCols))
                    @if(count($sprintInfoAry) > 0)
                        <td {{ $statusStyle }}><a href="https://jira.xarth.tv/issues/?jql=sprint{{ substr($sprintInfoAry[0], -5) }}" target="new">{{ substr($sprintInfoAry[3], 5) }}</a></td>
                    @else
                        <td {{ $statusStyle }}><i>TBD</i></td>
                    @endif
                @endif
                {{--components--}}
                @if(in_array("components", $reportCols))
                    @if(isset($issue->fields->components))
                        @php
                        $componentString = "";
                        //$lArray = implode(", ",$issue->fields->labels);
                        $components = $issue->fields->components;

                        foreach ($components as $component){
                            if (strlen($componentString) > 0) {
                            $componentString .= ", ";
                            }
                            $componentString .= "<a href='https://jira.xarth.tv/issues/?jql=project%20in%20(CB%2C%20TCP)%20and%20component%20in%20(\"" . $component->name . "\")'>" . $component->name . "</a>";
                            }
                        @endphp
                        <td {{ $statusStyle }}>{!! $componentString !!}</td>
                        @else
                        <td {{ $statusStyle }}></td>
                    @endif
                @endif
                {{--labels--}}
                @if(in_array("labels", $reportCols))
                    @if (isset($issue->fields->labels))
                        @php
                            $labelString = "";
                            //$lArray = implode(", ",$issue->fields->labels);
                            $labels = $issue->fields->labels;
                            foreach ($labels as $label){
                                if (strlen($labelString) > 0) {
                                    $labelString .= ", ";
                                }
                                $labelString .= "<a href='https://jira.xarth.tv/issues/?jql=project%20in%20(CB%2C%20TCP)%20and%20labels%20in%20(" . $label . ")'>" . $label . "</a>";
                            }
                        @endphp
                        <td {{ $statusStyle }}>{!! $labelString !!}</td>
                    @else
                        <td {{ $statusStyle }}></td>
                    @endif
                @endif
                {{--status--}}
                @if(in_array("status", $reportCols))
                    <td {{ $statusStyle }} style="text-align: right;">{{ $issue->fields->status->name }}</td>
                @endif
                {{--estimate--}}
                @if(in_array("estimate", $reportCols))
                    @if (Config::get("$project.$subproject.burndowns." . strtolower($issue->fields->project->key) . ".estimationMetric") == "duration")
                        <td {{ $statusStyle }} style="text-align: right;">
                            @if ($issue->fields->timeoriginalestimate)
                                {{ $issue->fields->timeoriginalestimate/3600/8 }}d
                            @else
                                <i>TBD</i>
                            @endif
                        </td>
                    @else
                        <td {{ $statusStyle }} style="text-align: right;">
                            @if (isset($issue->fields->customfield_10105))
                                {{ $issue->fields->customfield_10105 }}pt
                            @else
                                <i>TBD</i>
                            @endif
                        </td>
                    @endif
                @endif
            </tr>
            @php
                $n++;
            @endphp
        @endforeach
    </table>
</div>

<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>