<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>Help</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" /> TPM Automation Docs</span>
</div>
<br/>
<div class="block">
    <div class="header">Info</div>
    <table class="breakdown">
        <tr>
            <td>Code repo</td>
            <td><a href="https://git-aws.internal.justin.tv/twitch/TPM">https://git-aws.internal.justin.tv/twitch/TPM</a></td>
        </tr>
        <tr>
            <td>Team Members</td>
            <td><a href="https://wiki.twitch.com/display/PGM/TPM+Team+Members">https://wiki.twitch.com/display/PGM/TPM+Team+Members</a></td>
        </tr>
    </table>
</div>
<br />
<div class="block">
    <div class="header">Routes</div>
    <table class="breakdown">
        <tr>
            <th>Route</th>
            <th>Controller@Method</th>
            <th style="min-width: 450px;">Purpose</th>
        </tr>
        @foreach($routes as $route)
            <tr>
                <td><a href="/{{ $route->uri }}">{{ $route->uri }}</a></td>
                <td>{{ $route->action['uses'] }}</td>
                <td>
                    @if(isset($route->action['as']))
                        {{ title_case(str_replace("_", " ", $route->action['as'])) }}
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
</body>
</html>