<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }} Program Update</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;{{ $projectName }} Launched Items</span>
</div>
<br/>
@if ($launched)
<div class="block">
    <div class="header">Launched Epics in the Last 12 Weeks</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 80px;" nowrap>Launch Date</th>
            <th style="min-width: 100px;">Project</th>
            <th style="min-width: 50px;">Owner</th>
            <th style="min-width: 150px;">Launch Date Changelog</th>
            <th style="min-width: 70px;">Approx. Time Spent by CE (Jira)</th>
            <th style="min-width: 40px;"># of Stories</th>
            <th style="min-width: 40px;">Story Points</th>
            <th style="min-width: 180px;">Associated Sprints</th>
        </tr>
        @php
            $monthNumber = 0;
        @endphp
        @foreach($launched as $issue)
            @if (isset($issue->fields->duedate) && $monthNumber != Carbon\Carbon::parse($issue->fields->duedate)->month)
                <tr>
                    <td colspan="8" style="text-align: left; background-color: #eeeeee;"><b>Month of {{ Carbon\Carbon::parse($issue->fields->duedate)->startOfWeek()->format('F') }}</b>
                        @php
                            $monthNumber = Carbon\Carbon::parse($issue->fields->duedate)->month;
                        @endphp
                    </td>
                </tr>
            @elseif (!isset($issue->fields->duedate) && $monthNumber != "")
                <tr>
                    <td colspan="8" style="text-align: left; background-color: #eeeeee;"><b>Epics without specified due date</b></td>
                </tr>
                @php
                    $monthNumber = "";
                @endphp
            @endif
            <tr>
                @if (isset($issue->fields->duedate))
                    <td>{{ Carbon\Carbon::parse($issue->fields->duedate)->format('M d, Y') }}
                        @if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)
                        @endif
                    </td>
                @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                    <td><i>TBD</i></td>
                @else
                    <td><i>None</i></td>
                @endif

                <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @if (isset($issue->fields->assignee))
                    <td>
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  $issue->fields->assignee->displayName }}</a>
                    </td>
                @else
                    <td><i>None</i></td>
                @endif

                @if (isset($issue->changelog) && $histories = Jira::getDueDatesFromJiraChangelogHistory($issue->changelog->histories))
                    <td><ul>
                    @foreach ($histories as $history)
                        <li><b>{{ Carbon\Carbon::parse($history["due"])->format('M d') }}</b> ({{ strtok($history["name"], " ") }}, {{ Carbon\Carbon::parse($history["date"])->format('M d')}})</li>
                    @endforeach
                    </ul></td>
                @else
                    <td><i>No changes after initial</i></td>
                @endif
                <td>
                    {{ Jira::getTimeSpentWrapper($project, $issue->key) }} weeks
                </td>
                <td>
                    {{ $storiesCount = Jira::getNumberOfStories($project, $issue->key) }}
                </td>
                <td>
                    @if (isset($issue->fields->customfield_10105) && $issue->fields->customfield_10105 > 0)
                        {{ $issue->fields->customfield_10105 }}
                    @else
                        {{ Jira::getTotalStoryPoints($project, $issue->key) }}
                    @endif
                </td>
                <td>
                    @if ($storiesCount > 0 && $sprints = Jira::getSprintsForLinkedStories($project, $issue->key))
                        <ul>
                            @foreach($sprints as $sprint)
                                <li>{{ $sprint }}</li>
                            @endforeach
                        </ul>
                    @elseif (isset($issue->fields->customfield_10400) && $sprints = Jira::getSprints($issue->fields->customfield_10400))
                        <ul>
                            @foreach($sprints as $sprint)
                                <li>{{ $sprint }}</li>
                            @endforeach
                        </ul>
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
</div>
<br/>
@endif
</body>
</html>