<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>PDP Update</title>
    <style>
        body {
            margin: 10px;
            padding: 0;
            height: 100%;
            background-color: #FFFFFF;
            width: auto;
        }

        .title {
            margin: 8px;
            font-size: 18pt;
            font-weight: bold;
            font-family: helvetica, tahoma, arial;
            vertical-align: top;
            color: #5C459D;
        }

        .header {
            font-size: 12pt;
            margin-left: 8px;
            padding: 4px;
            font-family: helvetica, tahoma, arial;
            background-color: #5C459D;
            color: #FFFFFF;
            vertical-align: middle;
        }

        .info {
            margin: 8px;
        }

        .note {
            font-style: italic;
            font-size: 7pt;
        }

        .block {
            display: block;
            clear: both;
        }

        .icon {
            vertical-align: text-top;
            margin: 0;
            padding: 0;
        }

        .dot {
            height: 10px;
            width: 10px;
            border-radius: 50%;
            display: inline-block;
        }

        a:link, a.visited {
            color: #5C459D;
            text-decoration: none;
        }


        pre, p, .regular {
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            margin-left: 10px;
            margin-top: 4px;
        }

        table.story {
            border-collapse: collapse;
            margin: 8px;
            padding: 0;
            background-color: #fff;
            display: block;
        }

        td {
            border-collapse: collapse;
            border: 2px solid #DCDCDC;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
        }

        table.breakdown {
            border-collapse: collapse;
            border: 1px solid black;
            margin: 8px;
            padding: 0;
        }

        table.breakdown th {
            border: 1px solid #DCDCDC;
            margin: 2px;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            font-weight: bold;
            background-color: #cccccc;
        }

        table.breakdown td {
            border: 1px solid #DCDCDC;
            padding: 2px 4px;
            margin: 0;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            font-size: 9pt !important;
            line-height: 12pt;
            line-height: 12pt !important;
            text-align: left;
            vertical-align: top;
            -webkit-text-size-adjust: none;
        }


        ul {
            margin: 0;
            padding: 0 2px;
        }

        li {
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            text-align: left;
            margin: 0;
            list-style: inside circle;
            vertical-align: text-bottom;
            padding: 0;
        }

        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g {
            z-index: 1002;
        }


        #box {
            width: 28px;
            height: 9pt;
            margin: auto;
            border: 1px solid #000000;
        }

        .green {
            background-color: green;
            color: #FFFFFF;
        }

        .yellow {
            background-color: yellow;
        }

        .red {
            background-color: red;
            color: #FFFFFF;
        }

        .aqua {
            background-color: #0a69db;
            color: #FFFFFF;
        }

        .pink {
            background-color: #FF00FF;
        }

        .none {
            background-color: #FFFFFF;
        }

        .legend {
            padding: 2px 6px;
            display: inline-block;
            margin: 4px 0;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            border: 1px solid #000000;
        }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png"
                                                            alt="twitch logo" border="0"/>&nbsp;Product Development Process - Weekly Update</span>
</div>
<div class="block">
    <p>Please click the <b>project name</b> for the spec link and <img class="icon" src="https://i.ibb.co/dkWzx3j/jira.png"
                                 style="vertical-align: text-bottom;"> for the jira ticket, <img class="icon"
                                                                                                 src="https://i.ibb.co/BsCNQY8/star.png"
                                                                                                 style-"vertical-align:
        text-bottom;"> for items that are new this week.</p>
</div>
@if ($launched)
    <div class="block">
        <div class="header">Projects in Planning</div>
        <table class="breakdown">
            <tr>
                <th style="min-width: 80px;">Project</th>
                <th style="min-width: 50px;">STL</th>
                <th style="width: 55px;">Details</th>
                <th style="width: 55px">Days in Status</th>
                <th style="width: 140px"><a
                            href="https://wiki.twitch.com/pages/viewpage.action?pageId=221501439">Shared
                        Spaces</a></th>
            </tr>
            @php
                $statusSection = " ";
            @endphp
            @foreach($launched as $issue)
                @if (isset($issue->fields->status) && $statusSection != $issue->fields->status->name)
                    <tr>
                        <td colspan="5" style="background-color: #dddddd;"><span
                                    style="text-align: left; padding: 4px 0 4px; display: block; font-size: 10pt; font-weight: bold; margin: 0;">{{$issue->fields->status->name}}</span>
                            @php
                                $statusSection = $issue->fields->status->name;
                            @endphp
                        </td>
                    </tr>
                @endif
                @php
                    if(in_array("big-rock", $issue->fields->labels)) {
                        $style = "style=\"background-color: #E9DEFE;\"";
                    } else {
                        $style = "";
                    }
                @endphp
                <tr {!! $style !!}>
                    {{--Project Name--}}
                    @php
                        $isNew = false;
                        if(isset($issue->key)){
                            foreach ($newThisWeek as $newTicket){
                                if(isset($newTicket->key) && $newTicket->key == $issue->key){
                                  $isNew = true;
                                  break;
                                }
                            }
                        }
                    @endphp
                    {{--@if($isBigRock)
                        <td bgcolor="E9DEFF"><strong><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></strong></td>
                    @else
                        <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                    @endif
                    --}}
                    <td>
                        @if(isset($issue->fields->customfield_18201))
                            {{--@if($isNew)--}}
                            {{--<img class="icon" src="https://i.ibb.co/BsCNQY8/star.png" style="vertical-align: text-bottom;">--}}
                            {{--@endif--}}
                            <a href="{{ $issue->fields->customfield_18201 }}">{{ $issue->fields->summary }}</a>
                        @else
                            {{$issue->fields->summary}}
                        @endif
                    </td>


                    {{--STL--}}
                    @php
                        $stlOrPoc = Helpers::returnSTL($issue->key, $stls);
                        if($stlOrPoc == "<i>TBD</i>" and isset($issue->fields->assignee))
                            $stlOrPoc = $issue->fields->assignee->displayName;
                    @endphp

                    <td style="min-width: 70px; white-space: nowrap;" nowrap>{!! $stlOrPoc !!}</td>

                    {{--Details section--}}
                    <td nowrap>
                        {{--Emails removed--}}

                        {{--Slack--}}
                        @if (isset($issue->fields->customfield_13800))
                            <a href="slack://channel?team=T0266V6GF&id={{ $issue->fields->customfield_13800 }}"><img
                                        class='icon' src='https://image.ibb.co/hjgTTd/slack_purple.png'/></a>
                            {{--}}@else
                                {!! Helpers::returnSlackProject($issue->key, $stls) !!}--}}
                        @endif
                        {{--Docs--}}
                        {{--@if (isset($issue->fields->customfield_18201))
                            <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                        @endif--}}
                        {{--Jira - there is always a ticket link if there is a ticket --}}
                        @if (isset($issue->key))
                            <a href="https://jira.twitch.com/browse/{{$issue->key}}"><img class="icon"
                                                                                          src="https://i.ibb.co/dkWzx3j/jira.png"></a>
                        @else
                            <img class="icon" src="https://i.ibb.co/dkWzx3j/jira.png" height="18" width="18"/>
                        @endif
                        @if($isNew)
                            <img class="icon" src="https://i.ibb.co/BsCNQY8/star.png">
                        @endif
                    </td>

                    {{-- Days in Status --}}
                    <td style="text-align: right">
                        @if ($issue->changelog && isset($issue->fields->customfield_20800))
                            {{ \App\Http\Controllers\PDP::getTimeInStatus($issue->fields->customfield_20800, $issue->changelog) }}
                        @endif
                    </td>
                    <!--Project Process Next Step (date)-->
                    @if (isset($issue->fields->labels))
                        @php
                            $labelString = "";
                            //$lArray = implode(", ",$issue->fields->labels);
                            $labels = $issue->fields->labels;
                            foreach ($labels as $label){
                                if(!in_array ( $label , ["top-nav","channel","video-player","video-platform","theatermode","browse","homepage","left-column","creator-dashboard","chat","notifications","settings","navigation","creatoranalytics","creatorhome","stream-manager","expression","ads","commerce"])) continue;
                                else{
                                    if (strlen($labelString) > 0) $labelString .= ", ";
                                    $labelString .= "<a href=\"https://jira.xarth.tv/issues/?jql=issuetype%20%3D%20%22Project%20Plan%22%20and%20labels%20in%20(" . $label . ")\">" . $label . "</a>";
                                }
                            }
                        @endphp
                        <td>{!! $labelString !!}</td>
                    @else
                        <td></td>
                    @endif

                </tr>
            @endforeach
        </table>
    </div>
    <br/>
@endif
<br/>
<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>