<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>Spotlight Project Status</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
		.title img {vertical-align:bottom;}
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; font-size: 9pt;}
        .block { display: block; clear: both; }
        a:link, a.visited { color: #5C459D; }
		.velocityNote {margin-left:30px; color:gray; font-size: 9pt;}

        pre, p { font-family: helvetica, tahoma, arial; font-size: 10pt; margin-left: 10px; margin-top: 4px;}
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 10pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 10pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 10pt; font-size: 10pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }
        table.heading { margin-left:4px; width:100%;}
		table.heading td { border: none; font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }

        li { font-family: helvetica, tahoma, arial; font-size: 10pt;}

        rect, svg, g { z-index: 1002; }

        .green { background-color: #cceecc; white-space: nowrap;}
        .yellow { background-color: #ffffcc; white-space: nowrap;}
        .red { background-color: #ffcccc; white-space: nowrap; }
        .blue { background-color: #ddeeff; white-space: nowrap;}
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap">
	@if (isset($message))
		<img src="{{$message->embed(base_path() .'/resources/assets/img/spotlighticon.jpg') }}" alt="spotlight icon" border="0"  width="27" height="27" style="vertical-align:middle" />
	@else
		<img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" style="vertical-align:middle"/>
	@endif	
	[Spotlight] Project Status - Biweekly Update</span> <br/>
</div>
<div class="block">
	<table class="heading" width="100%">
		<tr>
			<td bgcolor="#5c459d"><font color="white">Summary</font></td>
		</tr>
	</table>
    <p>
		<a href="https://docs.google.com/document/d/19s4QVSPUvpRl0aunUdZ4HTXOVTlQd6L3ZSG6xeJveuU/edit?usp=sharing" target=_blank>Spotlight</a> is Twitch’s first-party broadcasting application. 
		@if (isset($epic))
			<a href="https://jira.twitch.com/browse/{{$epic[0]->key}}" target=_blank>{{$epic[0]->fields->customfield_11001}}</a> milestone is <span class="{{strtolower($epic[0]->fields->customfield_17202->value)}}"> <b>{{strtoupper($epic[0]->fields->customfield_17202->value)}}</b></span> for {{$epic[0]->fields->duedate}}.
		@endif
		We have completed {{$allIssuesInEpic[0]}}% ({{$allIssuesInEpic[1]}} of {{$allIssuesInEpic[2]}}) of the issues needed to make that date. For the overall project, {{$allIssues[0]}}% ({{$allIssues[1]}} of {{$allIssues[2]}}) of the issues are completed for a 2020 MVP launch. In the last 2 weeks, we added {{$createdIssues[3]}} Bugs and {{$createdIssues[2]}} Stories ({{$createdIssues[1]}} Story Points),
		@if (isset($doneIssues))
			and completed <a href="https://jira.xarth.tv/issues/?jql=project%20%3D%20SLP%20AND%20resolved%20%3E%3D%20-2w%20AND%20resolution%20in%20(Done%2C%20Fixed)%20AND%20issuetype%20!%3D%20Epic%20ORDER%20BY%20resolutiondate%20DESC" target=_blank>{{$doneIssues[0]}} issues</a> ({{$doneIssues[2]}} Bugs and {{$doneIssues[1]}} Stories).
		@endif
	</p>
	<p>{!!$emailSummary!!}</p>
    <p>
    	<b>For the latest progress on the project, please visit the <a href="https://jira.xarth.tv/secure/Dashboard.jspa?selectPageId=33211" target=_blank>Spotlight Launch Readiness Dashboard</a>.</b> For high-level Spotlight milestones and dates, please visit the <a href="https://wiki.twitch.com/display/DESKTOP/Spotlight" target=_blank>Spotlight wiki</a>.
	</p>

	<p>
<!--	TODO: grab image dynamically from source; rn it's hardcoded to pull from local path-->
		@if (isset($message))
			<img src="{{$message->embed(base_path() .'/resources/assets/img/pubchart.png') }}" alt="spotlight sprint velocity" border="0"/>
		@else
			<img src="https://docs.google.com/a/justin.tv/spreadsheets/d/e/2PACX-1vTrnYSZe8KqnjGioujTkW4ye3avNvgBBheM11ArwOrbEeh_t6KzuqVMV4W00gjDei-mhPmv3dSA4SZ1/pubchart?oid=1143372435&format=image" alt="spotlight sprint velocity" border="0" />
		@endif
		<br/>
		<span class="velocityNote">Note that Bugs and Tasks are 0 story points therefore this reflects velocity for actual feature work.</span><br/>
</div>
@if (isset($blocked))
<div class="block">
<table class="heading" width="100%">
		<tr>
			<td bgcolor="#5c459d"><font color="white">External Dependencies</font></td>
		</tr>
	</table>
    <table class="breakdown">
        <tr>
			<th>T</th>
            <th style="min-width: 70px;">Issue Key</th>
            <th style="min-width: 100px;">Milestone</th>
            <th style="min-width: 70px;">Depends On Working With</th>
			<th>Due Date</th>
        </tr>
        @foreach($blocked as $issue)
		<tr>
			<td>
			@if (isset($message))
				<img src="{{$message->embed(base_path() .'/resources/assets/img/epic.png') }}" alt="epic" border="0"/>
			@else
				<img src="https://jira.atlassian.com/secure/viewavatar?size=xsmall&avatarId=51497&avatarType=issuetype" alt="epic" />
			@endif
			</td>
			<td><a href="https://jira.twitch.com/browse/{{ $issue->key }}" target=_blank>{{ $issue->key }}</a></td>
			<td>{{ $issue->fields->summary }}</td>
			<td>
			@if (isset($issue->fields->issuelinks))
				@foreach($issue->fields->issuelinks as $linkedissue)
					@if (isset($linkedissue->type->inward))
						@if ($linkedissue->type->inward == "is blocked by")
							@if (isset($linkedissue->inwardIssue))
								@if ("Done" != $linkedissue->inwardIssue->fields->status->name)
										<a href="https://jira.twitch.com/browse/{{ $linkedissue->inwardIssue->key }}" target=_blank>{{$linkedissue->inwardIssue->key}}</a>
								@endif
							@endif
						@endif
					@endif
				@endforeach
			@endif
			</td>
			   <td style="white-space: nowrap;">
			   <!-- 2 weeks earlier than Spotlight's due date for buffer -->
				{{ Carbon\Carbon::parse($issue->fields->duedate)->subDays(14)->format('Y-m-d') }}
				</td>
			</tr>
        @endforeach
			<tr>
				<td colspan="5">
				For a full list of dependencies and their risk, see the <a href="https://docs.google.com/document/d/1b5bysqroZJo7jumOWcAebvXRoNNAEONa_2MlBhL90Oc/edit" target=_blank>Team Dependencies doc</a>. Due date shown is the requested target for the dependent task.
				</td>
			</tr>
    </table>
</div>
<br/>
@endif
@if (isset($planned))
<div class="block">
	<table class="heading" width="100%">
		<tr>
			<td bgcolor="#5c459d"><font color="white">Planned Issues (Next 2 Weeks)</font></td>
		</tr>
	</table>
    <table class="breakdown">
        <tr>
			<th>T</th>
            <th style="min-width: 70px;">Issue Key</th>
            <th style="min-width: 100px;">Epic</th>
            <th style="min-width: 100px;">Summary</th>
            <th style="min-width: 70px;">Status</th>
        </tr>
		<?php  
			$storytotal=0;
			$bugtotal=0;
		?>
        @foreach($planned as $issue)
			<tr>
				<td>
				@if (isset($message))
					@if ("Story" == $issue->fields->issuetype->name)
						<img src="{{$message->embed(base_path() .'/resources/assets/img/story.png') }}" alt="story" />
						<?php $storytotal++ ?>
					@elseif ("Bug" == $issue->fields->issuetype->name)
						<img src="{{$message->embed(base_path() .'/resources/assets/img/bug.png') }}" alt="bug" />
						<?php $bugtotal++ ?>
					@elseif ("Task" == $issue->fields->issuetype->name)
						<img src="{{$message->embed(base_path() .'/resources/assets/img/task.png') }}" alt="task" />
					@else 
						<img src="{{$message->embed(base_path() .'/resources/assets/img/story.png') }}" alt="story" />
					@endif
				@else
					@if ("Story" == $issue->fields->issuetype->name)
						<img src="https://jira.atlassian.com/secure/viewavatar?size=xsmall&avatarId=51505&avatarType=issuetype" alt="story" />
						<?php $storytotal++ ?>
					@elseif ("Bug" == $issue->fields->issuetype->name)
						<img src="https://jira.atlassian.com/secure/viewavatar?size=xsmall&avatarId=51493&avatarType=issuetype" alt="bug" />
						<?php $bugtotal++ ?>
					@elseif ("Task" == $issue->fields->issuetype->name)
						<img src="https://jira.atlassian.com/secure/viewavatar?size=xsmall&avatarId=51508&avatarType=issuetype" alt="task" />
					@else 
						<img src="https://jira.atlassian.com/secure/viewavatar?size=xsmall&avatarId=51505&avatarType=issuetype" alt="story" />
					@endif
				@endif
				</td>
				<td style="white-space: nowrap;"><a href="https://jira.twitch.com/browse/{{ $issue->key }}" target=_blank>{{ $issue->key }}</a></td>
				<td style="white-space: nowrap;">
				<!-- TODO: grab issue's epic name -->
				@if ("SLP-765" == $issue->fields->customfield_11000)
					First Time User Experience
				@elseif ("SLP-51" == $issue->fields->customfield_11000)
					Basic Twich Alerts
				@elseif ("SLP-276" == $issue->fields->customfield_11000)
					Limited Public Beta
				@elseif ("SLP-685" == $issue->fields->customfield_11000)
					Performance & Automation
				@elseif ("SLP-75" == $issue->fields->customfield_11000)
					Test Automation
				@elseif ("SLP-509" == $issue->fields->customfield_11000)
					Open Beta
				@elseif ("SLP-1968" == $issue->fields->customfield_11000)
					Open Beta Fast Follow
				@elseif ("SLP-273" == $issue->fields->customfield_11000)
					MVP
				@elseif ("SLP-274" == $issue->fields->customfield_11000)
					Post-MVP Launch
				@endif
				</td>
				<td>
               		{{ $issue->fields->summary }}
				</td>
				<?php
/*
	TODO: optimize. If a ticket is in "Blocked" due to a dependency within the team, then just display TODO instead of Blocked. Iterate through linked tickets and compare project to see if it's an internal dependency.
*/
				$notExternallyBlocked = false;
				?>
			@if ("Blocked" == $issue->fields->status->name)				
				@if (isset($issue->fields->issuelinks))
					<td 
					@foreach($issue->fields->issuelinks as $linkedissue)
						@if (isset($linkedissue->type->inward))
							@if ($linkedissue->type->inward == "is blocked by")
								@if (isset($linkedissue->inwardIssue))
									@if (strlen(strstr($linkedissue->inwardIssue->key,"SLP")) > 0 || strlen(strstr($linkedissue->inwardIssue->key,"DESKTOP")) > 0)
										class="blue"
										<?php
										$notExternallyBlocked = true;
										?>
										@break
									@endif
								@endif
<!--							@else
								class="red"
								@break
-->
							@endif
						@endif
					class="red"
					@endforeach
					>
				@else
					<td class="red">
				@endif
			@elseif ("Done" == $issue->fields->status->name)
				<td class="green">
			@elseif ("In Review" == $issue->fields->status->name || "In Progress" == $issue->fields->status->name)
				<td class="yellow">
			@elseif ("TODO" == $issue->fields->status->name)
				<td class="blue">
			@else
				<td style="white-space: nowrap;">
			@endif
			
				@if ($notExternallyBlocked == true)
					TODO
				@else
					{{$issue->fields->status->name}}
				@endif
            	</td>
            </tr>
        @endforeach
    </table>
</div>
<br/>
@endif

<div class="block">
	<table class="heading" width="100%">
		<tr>
			<td bgcolor="#5c459d"><font color="white">Contact Info</font></td>
		</tr>
	</table>
 
    {!! $contacts !!}
</div>

</body>
</html>