<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }} Program Update</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ol { margin: 0; padding: 0 0 0 25px; }
        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; list-style-type: decimal; vertical-align: text-bottom; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;{{ $projectName }} Story Points</span>
</div>
<br/>
@if ($points)
<div class="block">
    <div class="header">Story Points with Estimates: Points to "In-Progress to Done" Time for the Last {{ $weeks }} @choice ('week|weeks', $weeks)</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 80px;" nowrap>Story Point</th>
            <th style="width: 100px;" nowrap>Number of Stories with this Point Value</th>
            <th style="min-width: 100px;" nowrap>Mean (Days)</th>
            <th style="min-width: 100px;" nowrap>Std Deviation (Days)</th>
            <th style="min-width: 100px;" nowrap>Median (Days)</th>
            <th style="min-width: 100px;" nowrap>Mode (Days)</th>
            <th style="min-width: 100px;" nowrap>Range (Days)</th>
            <th style="min-width: 100px;" nowrap>Raw Data (Stories)<br />Click on Transitions in Jira</th>
        </tr>
        @foreach($points as $point => $values)
            <tr>
                <td style="text-align: right;"><span style="font-size: 14pt; font-weight: bold;">{{ $point }}</span></td>
                <td style="text-align: right;">{{ count($values) }}</td>
                <td style="text-align: right;">{{ number_format(Helpers::mmmr($values, "mean")/8, 1) }}</td>
                <td style="text-align: right;">{{ number_format(Helpers::stats_standard_deviation($values)/8, 1) }}</td>
                <td style="text-align: right;">{{ number_format(Helpers::mmmr($values, "median")/8, 1) }}</td>
                <td style="text-align: right;">{{ number_format(Helpers::mmmr($values, "mode")/8, 1) }}</td>
                <td style="text-align: right;">{{ number_format(max($values)/8, 1) }} -  {{ number_format(min($values)/8, 1) }} = {{ number_format(Helpers::mmmr($values, "range")/8, 1) }}</td>
                <td>
                    <ol>
                    @foreach ($values as $key => $value)
                         <li>
                             [{{ $storyDetails[$key]['resolution'] }}]
                             [<a href="http://jira.xarth.tv/browse/{{ $key }}" target="_blank">{{ $key }}</a>]
                             {{ $storyDetails[$key]['summary'] }}
                             <b>
                             @php
                                 Carbon\CarbonInterval::setCascadeFactors([
                               'minutes' => [60, 'seconds'],
                               'hours' => [60, 'minutes'],
                               'days' => [8, 'hours'],
                               'weeks' => [99999999, 'days'],
                             ]);
                             echo "(" . Carbon\CarbonInterval::hours($value)->cascade()->forHumans() . ")";
                             @endphp
                             </b>
                         </li>
                    @endforeach
                    </ol>
                </td>
            </tr>
        @endforeach
    </table>
</div>
<br/>
@endif
</body>
</html>