<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>VX Bi-Weekly Program Update</title>
    <style>
        body {
            margin: 10px;
            padding: 0;
            height: 100%;
            background-color: #FFFFFF;
            width: auto;
        }

        .title {
            margin: 8px;
            font-size: 18pt;
            font-weight: bold;
            font-family: helvetica, tahoma, arial;
            vertical-align: top;
            color: #5C459D;
        }

        .header {
            font-size: 12pt;
            margin-left: 8px;
            padding: 4px;
            font-family: helvetica, tahoma, arial;
            background-color: #5C459D;
            color: #FFFFFF;
            vertical-align: middle;
        }

        .info {
            margin: 8px;
        }

        .note {
            font-style: italic;
            font-size: 7pt;
        }

        .block {
            display: block;
            clear: both;
        }

        .icon {
            vertical-align: text-top;
            margin: 0;
            padding: 0;
        }

        .dot {
            height: 10px;
            width: 10px;
            border-radius: 50%;
            display: inline-block;
        }

        a:link, a.visited {
            color: #5C459D;
            text-decoration: none;
        }


        pre, p, .regular {
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            margin-left: 10px;
            margin-top: 4px;
        }

        table.story {
            border-collapse: collapse;
            margin: 8px;
            padding: 0;
            background-color: #fff;
            display: block;
        }

        td {
            border-collapse: collapse;
            border: 2px solid #DCDCDC;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
        }

        table.breakdown {
            border-collapse: collapse;
            border: 1px solid black;
            margin: 8px;
            padding: 0;
        }

        table.breakdown th {
            border: 1px solid #DCDCDC;
            margin: 2px;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            font-weight: bold;
            background-color: #D4D4D4;
        }

        table.breakdown td {
            border: 1px solid #DCDCDC;
            padding: 2px 4px;
            margin: 0;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            font-size: 9pt !important;
            line-height: 12pt;
            line-height: 12pt !important;
            text-align: left;
            vertical-align: top;
            -webkit-text-size-adjust: none;
        }


        ul {
            margin: 0;
            padding: 0 2px;
        }

        li {
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            text-align: left;
            margin: 0;
            list-style: inside circle;
            vertical-align: text-bottom;
            padding: 0;
        }

        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g {
            z-index: 1002;
        }


        #box {
            width: 28px;
            height: 9pt;
            margin: auto;
            border: 1px solid #000000;
        }

        .green {
            background-color: green;
            color: #FFFFFF;
        }

        .yellow {
            background-color: yellow;
        }

        .red {
            background-color: red;
            color: #FFFFFF;
        }

        .aqua {
            background-color: #0a69db;
            color: #FFFFFF;
        }

        .pink {
            background-color: #FF00FF;
        }

        .none {
            background-color: #FFFFFF;
        }

        .legend {
            padding: 2px 6px;
            display: inline-block;
            margin: 4px 0;
            font-family: helvetica, tahoma, arial;
            font-size: 9pt;
            border: 1px solid #000000;
        }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;Viewer Experience Bi-Weekly Program Update: {{ date('M j', strtotime('-2 weeks')) }} - {{ date('M j') }}</span>
</div>
<div class="block">
<p>Click <b>project name</b> to open the associated Jira ticket, <img src="https://image.ibb.co/c4NDuJ/email_purple.png" style="vertical-align: text-bottom;"> for contact emails, <img src="https://image.ibb.co/dNJ8Td/doc_purple.png" style="vertical-align: text-bottom;"> for product spec, <img src="https://i.ibb.co/Ch233XL/design-spec-icon2.png" style="vertical-align: text-bottom;"> for design spec, <img src="https://image.ibb.co/cPKF2U/tech_spec_icon.png" style="vertical-align: text-bottom;"> for tech spec, <img src="https://i.ibb.co/Qv4yjBc/product-results-icon.png" style="vertical-align: text-bottom;"> for product results.</p>
<div class="block">
<p>To add a status update to the "Notes" column below: click "Edit" on the Jira ticket and under the WPU tab use the "Project Summary Status" field.</p>
</div>

@if ($launched && count($launched)>0)
<div class="block">
    <div class="header">Launched Since Last Report</div>
    <table class="breakdown">
        <tr>
            <th style="width:50px">Launch Date</th>
            <th style="min-width: 10px;">Project</th>
            <th style="min-width: 10px;">PM</th>
            <th style="min-width: 10px;">EM</th>
            <th style="min-width: 10px;">TPM</th>
            <th style="min-width: 80px;">Details</th>
            <th style="min-width: 10px;">Notes</th>
        </tr>
        @php
            $statusSection = " ";
        @endphp
        @foreach($launched as $issue)
            <tr>
                <!--Due Date-->
                @if (isset($issue->fields->duedate))
                    <td>
                        {{ Carbon\Carbon::parse($issue->fields->duedate)->format('M j') }}
                    </td>
                @else <td><i>TBD</i></td>
                @endif
                {{--Project Name--}}
                @php
                    $isBigRock = in_array("big-rock", $issue->fields->labels);//loose comparison
                @endphp
                @if($isBigRock)
                    <td bgcolor="E9DEFF"><strong><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></strong></td>
                @else
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @endif
                {{--PM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18003->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18003->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18003->displayName) }}</a>
                    @endif
                </td>
                {{--EM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18004->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18004->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18004->displayName) }}</a>
                    @endif
                {{--TPM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18005->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18005->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18005->displayName) }}</a>
                    @endif
                </td>
                {{--Details section--}}
                <td nowrap>
                    {{--Emails--}}
                    @if (isset($issue->fields->customfield_21635))
                        <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @elseif (isset($issue->fields->assignee))
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @endif
                    {{--Product Spec--}}
                    @if (isset($issue->fields->customfield_18201))
                        <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                    @endif
                    {{--Design Spec--}}
                    @if (isset($issue->fields->customfield_21324))
                        <a href="{{$issue->fields->customfield_21324}}"><img class="icon" src="https://i.ibb.co/Ch233XL/design-spec-icon2.png"/></a>
                    @endif
                    {{--Tech Spec--}}
                    @if (isset($issue->fields->customfield_18401))
                        <a href="{{$issue->fields->customfield_18401}}"><img class="icon" src="https://image.ibb.co/cPKF2U/tech_spec_icon.png"/></a>
                    @endif
                    {{--Product Results--}}
                    @if (isset($issue->fields->customfield_21636))
                        <a href="{{$issue->fields->customfield_21636}}"><img class="icon" src="https://i.ibb.co/Qv4yjBc/product-results-icon.png"/></a>
                    @endif
                </td>
                <!-- Notes - Project Status Summary-->
                <td>
                    @if(isset($issue->fields->customfield_17802))
                        {{$issue->fields->customfield_17802}}
                        <span class="note">(updated {{ \App\Http\Controllers\VX::getTimeSinceLastChange($issue->fields->customfield_20800, $issue->changelog, "Project Status Summary") }}d ago)</span>
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
</div>
@endif
<br/>
@if ($active)
<div class="block">
    <div class="header">Programs in Flight</div>
    <table class="breakdown">
        <tr>
            <th style="width:60px">Target</th>
            <th style="min-width: 10px;">Project</th>
            <th style="min-width: 10px;">PM</th>
            <th style="min-width: 10px;">EM</th>
            <th style="min-width: 10px;">TPM</th>
            <th style="min-width: 80px;">Details</th>
            <th style="width:55px">Days in Status</th>
            <th style="min-width: 10px;">Notes</th>
        </tr>
        @php
            $statusSection = " ";
        @endphp
        @foreach($active as $issue)
            @if (isset($issue->fields->status) && $statusSection != $issue->fields->status->name)
                <tr>
                    <td colspan="8" style="text-align: left; background-color: #eeeeee;"><b> {{$issue->fields->status->name}} </b>
                        @php
                            $statusSection = $issue->fields->status->name;
                        @endphp
                    </td>
                </tr>
            @endif
            <tr>
             <!--Target (Due Date)-->
                @if (isset($issue->fields->duedate))
                    <td>
                        @if (isset($issue->fields->customfield_17202))
                            @if($issue->fields->customfield_17202->value == "Green")
                                <span class="dot green"></span>
                            @elseif($issue->fields->customfield_17202->value == "Yellow")
                                <span class="dot yellow"></span>
                            @elseif($issue->fields->customfield_17202->value == "Red")
                                <span class="dot red"></span>
                            @elseif($issue->fields->customfield_17202->value == "On Hold")
                                <span class="dot yellow"></span>
                            @elseif($issue->fields->customfield_17202->value == "In Planning")
                                <span class="dot aqua"></span>
                            @else
                                <span class="dot green"></span>
                            @endif
                        @else
                            <span class="dot gray"></span>
                        @endif
                        {{ Carbon\Carbon::parse($issue->fields->duedate)->format('M j') }}
                    </td>
                @else <td><i>TBD</i></td>
                @endif
                {{--Project--}}
                @php
                    $isBigRock = in_array("big-rock", $issue->fields->labels);//loose comparison
                @endphp
                @if($isBigRock)
                    <td bgcolor="E9DEFF"><strong><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></strong></td>
                @else
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @endif
                </td>

                {{--PM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18003->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18003->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18003->displayName) }}</a>
                    @endif
                </td>
                {{--EM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18004->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18004->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18004->displayName) }}</a>
                    @endif
                </td>
                {{--TPM--}}
                <td nowrap>
                    @if(isset($issue->fields->customfield_18005->displayName))
                        <a href="mailto:{{ $issue->fields->customfield_18005->emailAddress }}">{{  \App\Http\Controllers\VX::getShortName($issue->fields->customfield_18005->displayName) }}</a>
                    @endif
                </td>
                {{--Details--}}
                <td nowrap>
                    {{--Emails--}}
                    @if (isset($issue->fields->customfield_21635))
                        <a href="mailto:{{ Helpers::sanitize($issue->fields->customfield_21635) }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @elseif (isset($issue->fields->assignee))
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}"><img class="icon" src="https://image.ibb.co/c4NDuJ/email_purple.png"/></a>
                    @endif
                    {{--Product Spec--}}
                    @if (isset($issue->fields->customfield_18201))
                        <a href="{{ $issue->fields->customfield_18201 }}"><img class="icon" src="https://image.ibb.co/dNJ8Td/doc_purple.png"/></a>
                    @endif
                    {{--Design Spec--}}
                    @if (isset($issue->fields->customfield_21324))
                        <a href="{{$issue->fields->customfield_21324}}"><img class="icon" src="https://i.ibb.co/Ch233XL/design-spec-icon2.png"/></a>
                    @endif
                    {{--Tech Spec--}}
                    @if (isset($issue->fields->customfield_18401))
                        <a href="{{$issue->fields->customfield_18401}}"><img class="icon" src="https://image.ibb.co/cPKF2U/tech_spec_icon.png"/></a>
                    @endif
                    {{--Product Results--}}
                    @if (isset($issue->fields->customfield_21636))
                        <a href="{{$issue->fields->customfield_21636}}"><img class="icon" src="https://i.ibb.co/Qv4yjBc/product-results-icon.png"/></a>
                    @endif
                </td>

                <td>
                    {{ \App\Http\Controllers\VX::getTimeSinceLastChange($issue->fields->customfield_20800, $issue->changelog, "status") }} days
                </td>
                <!--Notes-->
                <td>
                    @if(isset($issue->fields->customfield_17802))
                        {{$issue->fields->customfield_17802}}
                        <span class="note">(updated {{ \App\Http\Controllers\VX::getTimeSinceLastChange($issue->fields->customfield_20800, $issue->changelog, "Project Status Summary") }}d ago)</span>
                    @endif
                    <!-- points completed/remaining - vx isn't using points for now so it just shows 0/0, but this should work if you start using points and uncomment -->
                    {{--@if(isset($issue->fields->issuetype) && $issue->fields->issuetype->name == "Epic" && isset($issue->key))
                        {{\App\Http\Controllers\VX::getPointsProgress($project,$issue->key)}}
                    @endif --}}
                </td>
            </tr>
        @endforeach
    </table>
</div>
@endif
<br/>
<div class="block">
    <div class="header">Communications & More Info</div>
    {!! $contacts !!}
</div>
</body>
</html>