<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>Directory Listing of WOR Programs</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; margin-bottom: 2px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin:  0px 8px 16px; padding: 0; }
        table.breakdown th { border: 1px solid #000; padding: 2px 4px; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 8pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }
        .grey { color: #c6c8ca; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js"></script>
</head>
<body>
<script>
    var clipboard = new ClipboardJS('.btn');

    clipboard.on('success', function(e) {
        console.info('Action:', e.action);
        console.info('Text:', e.text);
        console.info('Trigger:', e.trigger);

        e.clearSelection();
    });

    clipboard.on('error', function(e) {
        console.error('Action:', e.action);
        console.error('Trigger:', e.trigger);
    });
</script>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />Available Weekly Operation Review Programs</span>
</div>
<br/>
<div style="float: left;">
    <table class="breakdown" id="sheetData">
        <tr>
            <th>#</th>
            <th style="min-width: 120px;">Business Unit</th>
            <th style="min-width: 140px;">STL</th>
            <th>Included Jira Projects</th>
            <th style="min-width: 160px">Weekly Tracking Google Sheet</th>
        </tr>
        @php
            $i = 1;
        @endphp
        @foreach ($allConfigs as $name => $config)
            @if (isset($config["wor"]))
            <tr>
                <td>{{ $i }}</td>
                <td><a href="/twitch/wor/{{$name }}">{{ $config["wor"]["businessUnit"] }}</a></td>
                <td>{{ $config["wor"]["STL"] }}</td>
                <td>{{ $config["wor"]["projects"] }}</td>
                <td>
                    <a href="/twitch/wor/{{$name }}/write/test" target="_parent">Write to Sheet (Test)</a>&nbsp;|&nbsp;
                    <a href="https://docs.google.com/spreadsheets/d/{{ $config["wor"]["trackingSheet"]["sheetId"] }}/edit#gid=0" target="_blank">GSheet</a>
                </td>
            </tr>
            @php
                $i++;
            @endphp

            @endif
        @endforeach
    </table>
</div>
</body>
</html>