<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }}</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; margin-bottom: 2px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin:  0px 8px 16px; padding: 0; }
        table.breakdown th { border: 1px solid #000; padding: 2px 4px; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 8pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 8pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: #236429; color: #FFFFFF; }
        .yellow { background-color: #eed202; }
        .red { background-color: #FF625A; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }
        .grey { color: #c6c8ca; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" /> {{ $projectName }}
        <p style="font-size: 11pt; margin: 2px 2px 2px 33px;">Week: {{ $date["week"] }}, {{ $date["start"]->format("M d, Y") }} - {{ $date["end"]->format("M d, Y") }} | Projects in {{ Config::get($project . '.wor.projects') }}</p>
    </span>
</div>

<div style="float: left;">
    <div>
        <div class="header">Security Vulnerabilities</div>
        <p><a href="{{ Config::get('wor.securityVulnerabilities.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.securityVulnerabilities.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($securityVulnerabilities) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Due Date</th>
                <th>Updated</th>
            </tr>
            @if (count($securityVulnerabilities) == 0)
                <tr><td colspan="6">No issues found</td></tr>
            @endif
            @foreach($securityVulnerabilities as $issue)
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j/Y') }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    <div>
        <div class="header">Open Sec Remediation Items</div>
        <p><a href="{{ Config::get('wor.securityRemediation.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.securityRemediation.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($securityRemediation) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Due Date</th>
                <th>Updated</th>
            </tr>
            @if (count($securityRemediation) == 0)
                <tr><td colspan="6">No issues found</td></tr>
            @endif
            @foreach($securityRemediation as $issue)
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j/Y') }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    <div>
        <div class="header">Incidents in the Past 7 Days</div>
        <p><a href="https://jarvis.xarth.tv/">Link to Jarvis (Availability Portal)</a>
        <p><a href="{{ Config::get('wor.incidentsOwned.link') }}{{ preg_replace('/\[\[TEAM\]\]/m',  Config::get($project . '.wor.team'), Config::get('wor.incidentsOwned.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($incidentsOwned) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Updated</th>
                <th>Impacted Services</th>
            </tr>
            @if (count($incidentsOwned) == 0)
                <tr><td colspan="6">No issues found</td></tr>
            @endif
            @foreach($incidentsOwned as $issue)
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                    <td>{{ $issue->fields->customfield_21321 }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    <div>
        <div class="header">Open Availability Remediation Items</div>
        <p><a href="{{ Config::get('wor.availabilityRemediation.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.availabilityRemediation.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($availabilityRemediation) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Due Date</th>
                <th>Updated</th>
            </tr>
            @if (count($availabilityRemediation) == 0)
                <tr><td colspan="6">No issues found</td></tr>
            @endif
            @foreach($availabilityRemediation as $issue)
                {{--@php dd($issue); @endphp--}}
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j/Y') }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    @if ($overallServiceAvailability != null)
    <div>
        <div class="header">Service Availability</div>
        <p><a href="{{ Config::get($project . '.wor.availabilityPerService.link') }}&from={{ $date["start"]->timestamp  }}000&to={{ $date["end"]->timestamp }}000" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Overall (#: {{ count($availabilityPerService) }})</th>
                <th>Status ({{ round($overallServiceAvailability, 2) }}%)</th>
                <th>Target ({{ Config::get($project . ".wor.availabilityPerService.target") }}%)</th>
            </tr>
            @foreach($availabilityPerService as $name => $value)
                @if(Config::get($project . ".wor.availabilityPerService.yellowTarget")!= null && $value > Config::get($project . ".wor.availabilityPerService.yellowTarget"))
                    <tr class="green">
                @elseif($value > Config::get($project . ".wor.availabilityPerService.target"))
                    <tr class="yellow">
                @else
                    <tr class="red">
                @endif

                    <td>{{ $name }}</td>
                    <td style="text-align: right;">{{ $value }}%</td>
                    <td style="text-align: right;">{{ Config::get($project . ".wor.availabilityPerService.target") }}%</td>
                </tr>
            @endforeach
        </table>
    </div>
    @endif

    <div>
        <div class="header">Sev 3+ Issues</div>
        <p><a href="{{ Config::get('wor.sev3PlusJira.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.sev3PlusJira.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($sev3PlusJira) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Updated</th>
            </tr>
            @if (count($sev3PlusJira) == 0)
                <tr><td colspan="5">No issues found</td></tr>
            @endif
            @foreach($sev3PlusJira as $issue)
                {{--@php dd($issue); @endphp--}}
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words(htmlentities($issue->fields->summary), 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    <div>
        <div class="header">Issues OOSLA</div>
        <p><a href="{{ Config::get('wor.ooslaJira.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.ooslaJira.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Sev</th>
                <th>Summary (#: {{ count($ooslaJira) }})</th>
                <th>Status</th>
                <th>Age</th>
                <th>Due Date</th>
                <th>Updated</th>
            </tr>
            @if (count($ooslaJira) == 0)
                <tr><td colspan="6">No issues found</td></tr>
            @endif
            @foreach($ooslaJira as $issue)
                <tr>
                    <td>{{ $issue->fields->customfield_13601 ?  $issue->fields->customfield_13601->value : "" }}</td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ $issue->fields->customfield_20800 }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->duedate)->format('n/j/Y') }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>

    {{--<div>--}}
        {{--<div class="header">Average Time to Close COE</div>--}}
        {{--<p>Not Final -- Awaiting Calculation and Source</p>--}}
        {{--<table class="breakdown grey">--}}
            {{--@foreach($securityExpectations as $name => $value)--}}
                {{--<tr>--}}
                    {{--<td>{{ $name }}</td>--}}
                    {{--<td style="text-align: right;">{{ $value }}</td>--}}
                {{--</tr>--}}
            {{--@endforeach--}}
        {{--</table>--}}
    {{--</div>--}}
</div>

<div style="float: left;">
    <div>
        <div class="header">Unclassified Issues</div>
        <p><a href="{{ Config::get('wor.unclassifiedJira.link') }}{{ preg_replace('/\[\[PROJECT\]\]/m',  Config::get($project . '.wor.projects'), Config::get('wor.unclassifiedJira.jql')) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>P</th>
                <th>Summary (#: {{ count($unclassifiedJira) }})</th>
                <th>Status</th>
                <th>Updated</th>
            </tr>
            @if (count($unclassifiedJira) == 0)
                <tr><td colspan="4">No issues found</td></tr>
            @endif
            @foreach($unclassifiedJira as $issue)
                <tr>
                    <td><img src="{{ $issue->fields->priority->iconUrl }}"></td>
                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">[{{ $issue->fields->project->key }}]{!! \Illuminate\Support\Str::words($issue->fields->summary, 10, "...") !!}</a></td>
                    <td>{{ $issue->fields->status->name }}</td>
                    <td style="text-align: right;">{{ Carbon\Carbon::parse($issue->fields->updated)->format('n/j') }}</td>
                </tr>
            @endforeach
        </table>
    </div>
</div>


<div style="float: left;">
    <div>
        <div class="header">AWS Spend</div>
        <p><a href="{{ Config::get('wor.AWSCosts.link') }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Month</th>
                <th>Cost</th>
                <th>Cost Goal</th>
                <th>vs Cost Goal %</th>
                <th>Cost MoM %</th>
                <th>Utilization Opportunity</th>
                <th>$/kHW</th>
                <th>$/kHW Goal</th>
                <th>Utilization Score</th>
                <th>Utilization Goal</th>
            </tr>

            @foreach($AWSCosts as $name => $value)
                @if(isset($value["Cost"]) && filter_var($value["Cost"], FILTER_SANITIZE_NUMBER_INT) > filter_var($value["Cost Goal"], FILTER_SANITIZE_NUMBER_INT))
                    <tr class="red">
                @else
                    <tr>
                @endif
                    <td style="text-align: right; width: 50px;">{{ $name }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Cost"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Cost Goal"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["vs Cost Goal %"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Cost MoM %"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Utilization Opportunity"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["$/kHW"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["$/kHW Goal"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Utilization Score"] }}</td>
                    <td style="text-align: right; width: 50px;">{{ $value["Utilization Goal"] }}</td>
                </tr>
            @endforeach
        </table>
    </div>
    @if ($CWT != null)
    <div>
        <div class="header">Customer Wait Time</div>
        <p><a href="{{ preg_replace('/\[\[YEAR\]\]/m', 2019, preg_replace('/\[\[WEEK\]\]/m', 40, Config::get($project . '.wor.CWT.link'))) }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Experience</th>
                <th>Metric</th>
                <th style="width: 60px;">Baseline (ms)</th>
                <th style="width: 60px;">Current (ms)</th>
                <th style="width: 60px;">Phased Goal (ms)</th>
                <th style="width: 50px;">Phased Goal Dist (%)</th>
                <th style="width: 50px;">Phased Goal Dist (ms)</th>
            </tr>
            @if(count($CWT) == 0)
                <td colspan="7">No Data Found or Bad Auth Token</td>
            @else
                @foreach($CWT as $value)
                    @if($value["Phased Goal Dist (%)"] > 0)
                        <tr class="red">
                    @else
                        <tr>
                    @endif
                        <td>{{ $value["Experience"] }}</td>
                        <td>{{ $value["Metric"] }}</td>
                        <td style="text-align: right;">{{ $value["Baseline (ms)"] }}</td>
                        <td style="text-align: right;">{{ $value["Current"] }}</td>
                        <td style="text-align: right;">{{ $value["Phased Goal"] }}</td>
                        <td style="text-align: right;">{{ $value["Phased Goal Dist (%)"] }}</td>
                        <td style="text-align: right;">{{ $value["Phased Goal Dist (ms)"] }}</td>
                    </tr>
                @endforeach
            @endif
        </table>
    </div>
    @endif

    <div>
        <div class="header">Security Expectations</div>
        <p><a href="{{ Config::get('wor.securityExpectations.link') }}" target="new">Source Link</a></p>
        <table class="breakdown">
            @foreach($securityExpectations as $name => $value)
                @if($value < 0)
                    <tr class="red">
                @else
                    <tr>
                @endif
                    @if($loop->first)
                        <th>{{ $name }}</th>
                        <th style="text-align: right;">{{ $value }}</th>
                    @else
                        <td>{{ $name }}</td>
                        <td style="text-align: right;">{{ $value }}</td>
                    @endif
                </tr>
            @endforeach
        </table>
    </div>

    <div>
        <div class="header">Availability Expectations</div>
        <p><a href="{{ Config::get('wor.availabilityExpectations.KPIlink') }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Date</th>
                <th>2019 Goal</th>
                <th>% Complete</th>
                <th>Diff from goal</th>
                <th>Diff MoM</th>
            </tr>
            @if(count($overallAvailabilityTrend) > 0)
            @foreach($overallAvailabilityTrend as $date => $trend)
                @if($trend["Diff MoM"] < 0)
                    <tr class="red">
                @else
                    <tr>
                @endif
                    <td>{{ $date }}</td>
                    <td style="text-align: right;">{{ $trend["2019 Goal"] }}</td>
                    <td style="text-align: right;">{{ $trend["% Complete"] }}</td>
                    <td style="text-align: right;">{{ $trend["Diff from goal"] }}</td>
                    <td style="text-align: right;">{{ $trend["Diff MoM"] }}</td>
                </tr>
            @endforeach
            @else
                <tr><td colspan="5">Not setup yet</td></tr>
            @endif
        </table>
        @if(count($availabilityExpectations) > 0)
        <p><a href="{{ Config::get('wor.availabilityExpectations.link') }}" target="new">Source Link</a></p>
        <table class="breakdown">
            <tr>
                <th>Overall (#: {{ count($availabilityExpectations) }})</th>
                <th>Status (Done+2018+2019, {{ round($overallAvailabilityExpectations['status'], 0) }}%)</th>
                {{--[Done+2018+2019] / [Done+2019+2019+NoPlan+Won'tDo]--}}
                <th>{{ now()->year }} Target ({{ round($overallAvailabilityExpectations['target'], 0) }}%)</th>
            </tr>
            @foreach($availabilityExpectations as $name => $value)
                @if($value['status'] < $value['target'])
                    <tr class="red">
                @else
                    <tr>
                @endif
                    <td>{{ $name }}</td>
                    <td style="text-align: right;">{{ $value['status'] }}%</td>
                    <td style="text-align: right;">{{ $value['target'] }}%</td>
                </tr>
            @endforeach
        </table>
        @endif
    </div>
</div>

<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>