<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }}</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; margin-bottom: 2px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin:  0px 8px 16px; padding: 0; }
        table.breakdown th { border: 1px solid #000; padding: 2px 4px; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 8pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 8pt; font-size: 8pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }


        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }
        .grey { color: #c6c8ca; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js"></script>
</head>
<body>
<script>
    var clipboard = new ClipboardJS('.btn');

    clipboard.on('success', function(e) {
        console.info('Action:', e.action);
        console.info('Text:', e.text);
        console.info('Trigger:', e.trigger);

        e.clearSelection();
    });

    clipboard.on('error', function(e) {
        console.error('Action:', e.action);
        console.error('Trigger:', e.trigger);
    });
</script>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" /> {{ $projectName }}
        <p style="font-size: 11pt; margin: 2px 2px 2px 33px;">Week: {{ $date["week"] }}, {{ $date["start"]->format("M d, Y") }} - {{ $date["end"]->format("M d, Y") }} | Projects in {{ Config::get($project . '.wor.projects') }}</p>
    </span>
</div>
<br/>
<p style="font-size: 11pt; font-weight: bold;">Number of Cells of Data Written to this <a href="https://docs.google.com/spreadsheets/d/{{ Config::Get($project . ".wor.trackingSheet.sheetId") }}/edit#gid=0" target="_blank">sheet</a>: {{ $numberOfCellsUpdated }}&nbsp;
    <button class="btn" data-clipboard-action="copy" data-clipboard-target="#sheetData">
        Copy Week's Values to Clipboard
    </button>
</p>
<br />
@if ($numberOfCellsUpdated == 0)
    <p class="red" style="font-size: 11pt; padding: 8px;">This was only a test. If you meant to write to the Google sheet, click <a style="color: white; font-weight: bold;" href="/twitch/wor/{{ $project }}/write/final">here</a></p>
@endif

<br/>
<div style="float: left;">
    <table class="breakdown">
        @for($i = 0; $i < count($headers); $i++)
            <tr>
                <th> {{ $i }}</th>
                <th style="height: 16px;"> {{ $headers[$i] }}</th>
            </tr>
        @endfor
    </table>
</div>

<div style="float: left;">
    <table class="breakdown" id="sheetData">
        @for($i = 0; $i < count($sheetValues); $i++)
            <tr>
                <td style="height: 16px;"> {{ $sheetValues[$i][0] }}</td>
            </tr>
        @endfor
    </table>
</div>

<div style="clear: both;">
    <p><a href="/twitch/wor">WOR Directory - Listing of all available projects</a></p>
</div>
</body>
</html>