<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>{{ $projectName }} Program Update</title>
    <style>
        body { margin: 10px; padding: 0; height: 100%; background-color: #FFFFFF; width: auto; }
        .title { margin: 8px; font-size: 18pt; font-weight: bold; font-family: helvetica, tahoma, arial; vertical-align: top; color: #5C459D; }
        .header { font-size: 12pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #5C459D; color: #FFFFFF; vertical-align: middle; }
        .sub-header { font-size: 10pt; margin-left: 8px; padding: 4px; font-family: helvetica, tahoma, arial; background-color: #eeeeee; color: #5C459D; vertical-align: middle;
            font-weight: bold; }
        .info { margin: 8px; }
        .note { font-style: italic; font-size: 7pt; }
        .block { display: block; clear: both; }
        .icon { vertical-align: text-top; margin: 0; padding: 0; }
        .dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; }
        a:link, a.visited { color: #5C459D; }


        pre, p, .regular { font-family: helvetica, tahoma, arial; font-size: 9pt; margin-left: 10px; margin-top: 4px; }
        table.story { border-collapse: collapse; margin: 8px; padding: 0; background-color: #fff; display: block; }
        td { border-collapse: collapse; border: 2px solid #000; font-family: helvetica, tahoma, arial;  font-size: 9pt; }
        table.breakdown { border-collapse: collapse; border: 1px solid black; margin: 8px; padding: 0; }
        table.breakdown th { border: 1px solid #000; margin: 2px; font-family: helvetica, tahoma, arial; font-size: 9pt; font-weight: bold; background-color: #D4D4D4; }
        table.breakdown td { border: 1px solid #000; padding: 2px 4px; margin: 0; font-family: helvetica, tahoma, arial; font-size: 9pt; font-size: 9pt !important; line-height: 12pt; line-height: 12pt !important; text-align: left; vertical-align: top; -webkit-text-size-adjust: none; }


        ul { margin: 0; padding: 0 2px; }
        li { font-family: helvetica, tahoma, arial; font-size: 9pt; text-align: left; margin: 0; list-style: inside circle; vertical-align: text-bottom; padding: 0; }
        /*li:before {*/
        /*font-family: arial;*/
        /*font-size: 9pt;*/
        /*content: '\279D \00a0';*/
        /*display: inline-block;*/
        /*!*height: 1rem;  // or px or em or whatever*!*/
        /*!*width: 1rem;  // or whatever space you want*!*/
        /*}*/

        rect, svg, g { z-index: 1002; }

        #box { width: 28px; height: 9pt; margin: auto; border: 1px solid #000000; }
        .green { background-color: green; color: #FFFFFF; }
        .yellow { background-color: yellow; }
        .red { background-color: red; color: #FFFFFF; }
        .aqua { background-color: #0a69db; color: #FFFFFF; }
        .bigrock { background-color: #E9DEFE; color: #000000; }
        .pink { background-color: #FF00FF; }
        .none { background-color: #FFFFFF; }

        .legend { padding: 2px 6px; display: inline-block; margin: 4px 0; font-family: helvetica, tahoma, arial; font-size: 9pt; border: 1px solid #000000; }
    </style>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <script type="text/javascript">
        //custom error handling when not enough columns to draw the charts
        function errorHandler(errorMessage) {
            //curiosity, check out the error in the console
            console.log(errorMessage);

            //simply remove the error, the user never see it
            google.visualization.errors.removeError(errorMessage.id);
        }

        // Load the Visualization API and the piechart package.
        google.charts.load('current', {'packages': ['corechart']});

        // Set a callback to run when the Google Visualization API is loaded.
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
                <?php $i = 1; ?>
                    @foreach($modeGraphs as $key => $graph)
            var jsonData{{$i}} = $.ajax({
                    url: "/twitch/mode/{{ $project }}/{{ $key }}",
                    dataType: "json",
                    async: false
                }).responseText;


            // Create our data table out of JSON data loaded from server.
            var data{{$i}} = new google.visualization.DataTable(jsonData{{$i}});
            var formatter = new google.visualization.DateFormat({pattern: "MMM d"});
            formatter.format(data{{$i}}, 0);

            // Instantiate and draw our chart, passing in some options.
            // https://developers.google.com/chart/interactive/docs/gallery/columnchart#configuration-options
            var options = {
                title: '{{ $graph['title'] }}',
                titlePosition: 'out',
                axisTitlesPosition: 'out',
                titleTextStyle: {
                    color: "#000000",
                    fontName: "Helvetica, Tahoma, Arial",
                    fontSize: 12,
                    bold: true,
                    italic: false
                },
                chartArea: {
                    width: 400,
                    height: 150,
                },
                vAxis: {
                    title: "{{ $graph['vaxisTitle'] }}",
                    format: 'short',
                    minValue: 0,
                    gridlines: {count: 8},
                    textStyle: {
                        fontName: "Helvetica, Tahoma, Arial",
                        color: '#000000',
                        fontSize: 9,
                        bold: false,
                        italic: false
                    }
                },
                hAxis: {
                    title: '{{ $graph['haxisTitle'] }}',
                    slantedTextAngle: 90,
                    minValue: new Date({{ Carbon\Carbon::today()->subMonth(6)->format('Y') }}, {{ Carbon\Carbon::today()->subMonth(6)->format('m') }}, 1),
                    maxValue: new Date({{ Carbon\Carbon::today()->format('Y') }}, {{ Carbon\Carbon::today()->format('m') }}, 1),
                    textStyle: {
                        fontName: "Helvetica, Tahoma, Arial",
                        color: '#000000',
                        fontSize: 9,
                        bold: false,
                        italic: false
                    },
                    format: 'MMM d',
                    gridlines: {count: 8}
                },
                format: 'EEE, MMM d',
                width: 510,
                height: 220,
                legend: {
                    position: 'top',
                    maxLines: 1,
                    textStyle: {
                        fontSize: 10,
                        bold: false
                    }
                },
                series: {
                    1: { lineDashStyle: [2, 1] }
                }
            };

            var chart_div{{$i}} = document.getElementById('chart_div{{$i}}');
            var chart{{$i}} = new google.visualization.LineChart(document.getElementById("chart_div{{$i}}"));

            @if (app('request')->input('graph') == "image" or $graphJS == "image")
            google.visualization.events.addListener(chart{{$i}}, 'ready', function () {
                chart_div{{$i}}.innerHTML = '<a href="<?php echo str_replace("api/", "", $graph['mode']); ?>"><img src="' + chart{{$i}}.getImageURI() + '"></a>';
            });
            @endif

            //attach the error handler here, before draw()
            google.visualization.events.addListener(chart{{$i}}, 'error', errorHandler);
            chart{{$i}}.draw(data{{$i}}, options);
            <?php $i++; ?>
            @endforeach
        }
    </script>
</head>
<body>
<div class="title">
    <span style="text-wrap: none; white-space: nowrap"><img src="https://image.ibb.co/mFPhhe/twitch_logo.png" alt="twitch logo" border="0" />&nbsp;{{ $projectName }}
        ({{ Carbon\Carbon::today()->startOfWeek()->format('M d') }}
        - {{ Carbon\Carbon::today()->endOfWeek()->format('M d') }})</span>
</div>
<br/>
<div class="block">
    <div class="header">Mission Statement &amp; Exec Summary</div>
    {!! $wpuDigest !!}
</div>
@if ($insight != "SKIP")
    <div class="block">
        <div class="header">Creator and Product Insight</div>
        <p>{!! nl2br($insight) !!}</p>
    </div>
@endif
<br/>
<div class="block">
    <div class="header">WBR Metrics</div>
    {!! $wbrMetricsText !!}
    <br/>
    @if (sizeof($modeGraphs) != 0)
        @for($j = 1; $j < $i; $j++)
            <div style="float: left;" id="chart_div{{$j}}"></div>
        @endfor
    @endif
</div>

<div class="block">
    <div class="header">Program Updates</div>
    <div class="sub-header">In Development</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 70px;" nowrap>Target</th>
            <th style="min-width: 100px;">Project</th>
            <th style="min-width: 80px;">Owner</th>
            <th style="min-width: 35px;">Spec</th>
            <th style="min-width: 50px;">Staff Beta</th>
            <th style="min-width: 105px;">Dependencies</th>
            <th style="min-width: 120px;">Risks &amp; Notes</th>
        </tr>

        @foreach($issues as $issue)
            @php
                if(in_array("big-rock", $issue->fields->labels)) {
                    $rowcolor = "#E9DEFE";
                } else {
                    $rowcolor = "#FFFFFF";
                }
            @endphp
            <tr style="background-color: {{ $rowcolor }}">
                <td nowrap>
                    @if (isset($issue->fields->customfield_17202))
                        @if($issue->fields->customfield_17202->value == "Green")
                            <span class="dot green"></span>
                        @elseif($issue->fields->customfield_17202->value == "Yellow")
                            <span class="dot yellow"></span>
                        @elseif($issue->fields->customfield_17202->value == "Red")
                            <span class="dot red"></span>
                        @elseif($issue->fields->customfield_17202->value == "On Hold")
                            <span class="dot yellow"></span>
                        @elseif($issue->fields->customfield_17202->value == "In Planning")
                            <span class="dot aqua"></span>
                        @else
                            <span class="dot green"></span>
                        @endif
                    @else
                        <span class="dot green"></span>

                    @endif

                    @if (isset($issue->fields->duedate))
                        {{ Helpers::returnConfidenceDate($issue->fields->duedate) }}
                        @if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)
                            <br/>
                            <span style="margin-left: 14px; text-decoration: line-through">{{ Carbon\Carbon::parse($issue->fields->customfield_18001)->format('D, M d') }}</span>
                        @endif
                        </td>
                    @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                    <i>TBD</i></td>
                    @else
                    <i>TBD</i></td>
                    @endif

                    <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a>
                    </td>
                    @if (isset($issue->fields->assignee))
                        <td>
                            <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  $issue->fields->assignee->displayName }}</a>
                        </td>
                    @else
                        <td><i>None</i></td>
                    @endif

                    @if (isset($issue->fields->customfield_18201))
                        <td><a href="{{ $issue->fields->customfield_18201 }}">Link</a></td>
                    @else
                        <td><i>N/A</i></td>
                    @endif

                    @if (isset($issue->fields->customfield_15100))
                        <td>{{  Carbon\Carbon::parse($issue->fields->customfield_15100)->format('D, M d') }}</td>
                    @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                        <td>TBD</td>
                    @else
                        <td><i>N/A</i></td>
                    @endif

                    <td>

                            @if (isset($issue->fields->issuelinks))
                                <?php $teams = Jira::getDependencies($issue->key, $issue->fields->issuelinks); ?>
                                @if (count($teams) > 0)
                                        <ul>
                                    @foreach($teams as $team => $link)
                                        <li><a href="{{ $link }}">{{ $team }}</a></li>
                                    @endforeach
                                        </ul>
                                @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                                    <i>TBD</i>
                                @else
                                    <i>N/A</i>
                                @endif
                            @endif

                    </td>

                    @if (isset($issue->fields->customfield_17802))
                        <td style="min-width: 150px;">{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}
                    @else
                        <td style="min-width: 150px;">
                    @endif
                        <span class="note">({{ Carbon\Carbon::parse($issue->fields->updated)->format('m/d') }})</span></td>
            </tr>
        @endforeach
    </table>
</div>
<br/>
@if ($launched)
<div class="block">
    <div class="sub-header">Launched in the Last 15 Days</div>
    <table class="breakdown">
        <tr>
            <th style="min-width: 70px;" nowrap>Launched</th>
            <th style="min-width: 100px;">Project</th>
            <th>Owner</th>
            <th style="min-width: 120px;">Risks &amp; Notes</th>
        </tr>
        @foreach($launched as $issue)
            @php
                if(in_array("big-rock", $issue->fields->labels)) {
                    $rowcolor = "#E9DEFE";
                } else {
                    $rowcolor = "#FFFFFF";
                }
            @endphp
            <tr style="background-color: {{ $rowcolor }}">
                @if (isset($issue->fields->duedate))
                    <td>{{ Carbon\Carbon::parse($issue->fields->duedate)->format('D, M d') }}
                        @if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)
                            <br/>
                            <strike>{{ Carbon\Carbon::parse($issue->fields->customfield_18001)->format('D, M d') }}</strike>
                        @endif
                    </td>
                @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                    <td><i>TBD</i></td>
                @else
                    <td></td>
                @endif

                <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @if (isset($issue->fields->assignee))
                    <td>
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  $issue->fields->assignee->displayName }}</a>
                    </td>
                @else
                    <td><i>None</i></td>
                @endif

                @if (isset($issue->fields->customfield_17802))
                    <td>{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}</td>
                @else
                    <td></td>
                @endif
            </tr>
        @endforeach
    </table>
</div>
<br/>
@endif
<div class="block">
    <div class="sub-header">Roadmap</div>
    <p>This is a listing of all CE Roadmap items and their step within the Project Process. The Kanban board link is <a href="https://jira.xarth.tv/secure/RapidBoard.jspa?rapidView=997&view=detail&quickFilter=4886">here</a>. This is WIP as we figure out all the next step dates and roll out the process.</p>
    <table class="breakdown">
        <tr>
            <th style="min-width: 70px;">Target</th>
            <th style="min-width: 70px;">Project Step</th>
            <th style="min-width: 110px;">Project</th>
            <th>Owner</th>
            <th>Spec</th>
            <th>Design</th>
            <th style="min-width: 120px;">Shared Spaces</th>
            <th style="min-width: 120px;">Notes</th>
        </tr>
        @foreach($roadmap as $issue)
            @php
                if(in_array("big-rock", $issue->fields->labels)) {
                    $rowcolor = "#E9DEFE";
                } else {
                    $rowcolor = "#FFFFFF";
                }
            @endphp
            <tr style="background-color: {{ $rowcolor }}">
                @if (isset($issue->fields->duedate))
                    <td>{{ Helpers::returnConfidenceDate($issue->fields->duedate) }}
                        {{--@if (isset($issue->fields->duedate) && isset($issue->fields->customfield_18001) && $issue->fields->duedate != $issue->fields->customfield_18001)--}}
                        {{--<br /><strike>{{ Carbon\Carbon::parse($issue->fields->customfield_18001)->format('D, M d') }}</strike>--}}
                        {{--@endif--}}
                    </td>
                @elseif(isset($issue->fields->customfield_17202) && $issue->fields->customfield_17202->value == "In Planning")
                    <td><i>TBD</i></td>
                @else
                    <td><i>TBD</i></td>
                @endif

                @if (isset($issue->fields->status))
                    <td>{{ $issue->fields->status->name }}</td>
                @else
                    <td><i>N/A</i></td>
                @endif

                <td><a href="https://jira.twitch.com/browse/{{ $issue->key }}">{{ $issue->fields->summary }}</a></td>
                @if (isset($issue->fields->assignee))
                    <td>
                        <a href="mailto:{{ $issue->fields->assignee->emailAddress }}">{{  $issue->fields->assignee->displayName }}</a>
                    </td>
                @else
                    <td><i>TBD</i></td>
                @endif

                @if (isset($issue->fields->customfield_18201))
                    <td><a href="{{ $issue->fields->customfield_18201 }}">Link</a></td>
                @else
                    <td><i>N/A</i></td>
                @endif

                @if (isset($issue->fields->customfield_21324))
                    <td><a href="{{ $issue->fields->customfield_21324 }}">Link</a></td>
                @else
                    <td><i>N/A</i></td>
                @endif

                @if (isset($issue->fields->labels))
                    @php
                        $labelString = "";
                        //$lArray = implode(", ",$issue->fields->labels);
                        $labels = $issue->fields->labels;
                        foreach ($labels as $label){
                            if(!in_array ( $label , ["top-nav","channel","video-player","theatermode","browse","homepage","left-column","creator-dashboard","chat","notifications","settings","big-rock"])) continue;
                            else{
                                if (strlen($labelString) > 0) $labelString .= ", ";
                                $labelString .= "<a href=\"https://jira.xarth.tv/issues/?jql=issuetype%20%3D%20%22Project%20Plan%22%20and%20labels%20in%20(" . $label . ")\">" . $label . "</a>";
                            }
                        }
                    @endphp
                    <td>{!! $labelString !!}</td>
                @else
                    <td></td>
                @endif

                @if (isset($issue->fields->customfield_17802))
                    <td width="250">{!! Helpers::convertStringtoLinks($issue->fields->customfield_17802) !!}
                @else
                    <td width="250">
                        @endif
                        <span class="note">({{ Carbon\Carbon::parse($issue->fields->updated)->format('m/d') }})</span></td>
            </tr>
        @endforeach
    </table>
    <div>
        <span class="regular" style="font-weight: bold;">Legend:</span>
        <span class="legend"><span class="dot green"></span> On Track</span>
        <span class="legend"><span class="dot yellow"></span> Known Risks</span>
        <span class="legend"><span class="dot red"></span> Blocked / At-Risk</span>
        <span class="legend"><span class="dot aqua"></span> In Planning</span>
        <b>/</b> <span class="bigrock legend">Big Rock</span>
    </div>
</div>
<br/>
<div class="block">
    <div class="header">Contact Info</div>
    {!! $contacts !!}
</div>
</body>
</html>