<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//default if no path set
Route::get('/', function()
{
    return Redirect::to('twitch/wpu');
});


//instruction + help page. found here: http://localhost:8000/twitch
Route::get('twitch', 'Help@showRoutes')->name("help_page_to_show_routes");

//weekly program update + email
Route::get('twitch/wpu', 'WPU@showCompanyWPU')->name("company_wpu_driven_by_jira");
Route::get('twitch/wpu/mail/{type}', 'WPU@sendCompanyWPUEmail')->name("send_email_for_company_wpu_driven_by_jira");


//product development process email
Route::get('twitch/pdp', 'PDP@showPDPItem')->name("product_development_process_weekly_email");
Route::get('twitch/pdp/sharedspaces', 'PDP@showSharedSpaces');
Route::get('twitch/pdp/mail/{type}', 'PDP@sendPDPEmail')->name("send_email_for_pdp");


//WOR - weekly operational review
Route::get('twitch/wor', 'WOR@showAll')->name("weekly_operational_review_directory");
Route::get('twitch/wor/{project}', 'WOR@showPreview')->name("weekly_operational_review_table");
Route::get('twitch/wor/{project}/mail/{type}', 'WOR@sendEmail')->name("send_mail_for_the_weekly_operational_review_table");
Route::get('twitch/wor/{project}/write/{writeType}', 'WOR@writeHistoricalDataFromSheet')->name("wor_write_historical_data_into_spreadsheet");


//Creator team email
Route::get('twitch/wpu/creator', 'Creator@showReport')->name("creator_program_update");
Route::get('twitch/wpu/creator/mail/{type}', 'Creator@sendEmail')->name("send_email_for_creator");

//customized team report + email option
Route::get('twitch/wpu/{project}', 'WPU@showWPUItems')->name("team_wpu_driven_by_jira_where_project_is_defined_by_the_folder");
Route::get('twitch/wpu/{project}/mail', 'WPU@sendTeamWPUEmail', ['graph' => 'image'])->name("send_email_for_team_wpu_driven_by_jira_where_project_is_defined_by_the_folder");;
Route::get('twitch/wpu/{project}/{subproject}', 'GenericProject@showReport')->name("");

//create mode graph REST calls for consumption on team WPU
Route::get('twitch/mode/{project}/{token}', 'WPU@createGraphData')->name("graph_data_for_mode_driven_project_and_mode_token");


//launched items review
Route::get('twitch/launched/{project}/{team}', 'Launched@showLaunchedItem')->name("show_list_of_launched_items_pulled_from_jira_per_project");

//story points review
Route::get('twitch/storypoints/{project}/{team}', 'StoryPoints@showStoryPoints')->name("how_much_time_does_each_story_point_take");
Route::get('twitch/storypoints/{project}/{team}/{weeks}', 'StoryPoints@showStoryPoints')->name("how_much_time_does_each_story_point_take");

//generate fix version burndown for Google Charts
Route::get('twitch/fvburndown/{project}/{subproject}/{jiraproject}', 'FVBurndown@convertToGraphData')->name("generate_fix_version_burndown_graph_for_google_charts");


//VE team email & sitewide safety email
Route::get('twitch/ve', 'VE@showVEItem')->name("viewer_engagement_program_update");
Route::get('twitch/safety', 'Safety@showVEItem')->name("sitewide_safety");

//VX team email
Route::get('twitch/vx', 'VX@showVXItem')->name("viewer_experience_program_update");
Route::get('twitch/vx/mail/{type}', 'VX@sendVXEmail')->name("send_email_for_vx");

//Burndown jira points chart
Route::get('twitch/burndown', 'Burndown@showVEItem')->name("points_burndown_chart_for_an_epic");

//Central Science research email
Route::get('twitch/centsci', 'CentSci@showVEItem')->name("update_for_central_science_research_projects");

//slackpost bot
Route::get('twitch/slack/wpu/{project}/{type}', 'Slack@postDueDates')->name("slackbot_url_hook_for_sending_project_dates_to_channel"); //post launch slack channel
Route::get('twitch/slack/oe/{project}/{type}', 'Slack@postOEItems')->name("slackbot_url_hook_for_sending_oe_per_project_to_channel"); //post OE issues slack channel
Route::get('twitch/slack/mode/{project}/{type}', 'Slack@postModeData')->name("slackbot_url_hook_for_sending_mode_stats_to_channel"); //post OE issues slack channel

//client platforms: spotlight
Route::get('twitch/spotlight', 'Spotlight@showSpotlightItem')->name("client_platforms_>_browser_clients_>_spotlight_status");
Route::get('twitch/spotlight/mail/{type}', 'Spotlight@sendSpotlightEmail')->name("send_email_for_spotlight_status");

//fake money counter
//http://127.0.0.1/counter/2015-07-31/294275219/1.58
Route::get('counter/{date}/{amount}/{increment}', 'CounterController@showCount');