# basic_vpc

Create a basic VPC for your account.  We currently support 3-subnet regions.

# How to use

1. Make sure your AWS-CLI works. You may need to setup [isengard credentials](https://git-aws.internal.justin.tv/twitch/isengard_credentials) first.
2. Run on the CLI with the correct profile. (note: the script will use us-west-2 Oregon as the region by default, so make sure the region in your profile matches that)

```bash
< AWS_PROFILE=twitch-personal ./create_vpc.sh 
Verifying cli works ...
Account ID: 555125330048
Region:     us-west-2
Stack already exists. Updating and pulling existing information.  If you get a 'No updates are to be performed' error, ignore it

An error occurred (ValidationError) when calling the UpdateStack operation: No updates are to be performed.
here is your VPN information
VPC:             vpc-09841bd3b251cedc6
Public Subnets:  subnet-0fbf0db610c225761,subnet-029768353be92a110,subnet-05b49efe50ea96d13
Private Subnets: subnet-090e0ff12aeada126,subnet-090e0ff12aeada126,subnet-090e0ff12aeada126
Security Group:  sg-00f6e9556e6789a47
```

# Exports

You should expect at least the following cloudformation exports

* AllPublicSubnets
* AllPrivateSubnets
* VPC
* SecurityGroup
