# DEPRECATED

You probably don't need this.  [teleport-remote](https://wiki.twitch.com/display/SEC/Teleport+Remote) now gives you a `jumpbox`.  That is probably all you need.  This still exists mostly for reference. I recommend strongly just using the given jumpbox if you can.

# bastion_ldap_host

Are you using Fargate or lamda for your account and just need a bastion host to get inside your VPC?
If so, use this script!  It creates a bastion enabled EC2 host that uses LDAP authentication.
After setup, anyone on your team that's in the set ldap group can use bastion to SSH into your account.

# Prerequisites

1. This script's default values assume your account was [setup by basic_vpc](https://git-aws.internal.justin.tv/twitch/basic_vpc)
   or  [setup by #systems](https://wiki.twitch.com/display/AD/How+to+Set+Up+a+New+AWS+Account) or only has one VPC.
   If neither of these are true, you'll need to explicitly set the environment variables **VPC_ID** and **SUBNET_ID**.
2. Make sure your aws-cli works and you've setup a [LDAP private link](https://tps.internal.justin.tv) using tps.
   Ensure you setup the security group for your private link correctly.  There are some [instructions on the wiki](https://wiki.twitch.com/display/SYS/How+to+access+LDAP+with+TPS).
3. Set up the DNS name to resolve the LDAP private link on [Route 53](https://console.aws.amazon.com/route53). Create a new record set with the LDAP private link and the alias for this service, both of which were generated from TPS in the previous step.
4. Have deployed [teleport remote](https://wiki.twitch.com/display/SEC/Teleport+Remote) inside your private subnets.
   If the wiki is too confusing, you can try deploying the cluster via CLI ([See below](#Create bastion cluster via CLI)) 

# How to use
1) Pass the vpc endpoint hostname that tps created, along with your LDAP group and ACCOUNT_NAME to create_ldap_host.sh.  It will try to auto discover what your VPC/subnet information should be.

# Example output

Here is what it looked like when I ran it

```bash
> LDAP_GROUP=search-discovery LDAP_HOST=ldap-vpce-02dff9f9fca56be77.internal.justin.tv ACCOUNT_NAME=twitch-jlindamo-personal AWS_PROFILE=twitch-jlindamo-personal CLUSTER_NAME=twitch-jlindamo-personal ./create_ldap_host.sh

Waiting for changeset to be created..
Waiting for stack create/update to complete
Successfully created/updated stack - ldap-enabled-host
Done!

Find your host here: https://us-west-2.console.aws.amazon.com/ec2/home?region=us-west-2#Instances:search=i-014a38eacd0aab144;sort=instanceId
The host takes a few minutes to spin up.  Then, check the system log for your instance to see that it connected correctly
Finally, SSH into your host
Note: this process usually takes about 5-10 minutes
  TC=twitch-discovery-dev ssh 10.204.38.220

```

Another example from a more recent install:

`LDAP_HOST=ldap-vpce-09d1e8af11b347e9f.internal.justin.tv ACCOUNT_NAME=twitch-ext-disco-dev LDAP_GROUP=team-developer-success ./create_ldap_host.sh`

followed by usage:

`TC=twitch-ext-disco-dev-us-west-2 ssh -v 10.205.12.223`

To connect to a remote database through the bastion host, a command like this (shown utilizing a convenience hostname DNS entry I created for the above server):

`TC=twitch-ext-disco-dev-us-west-2 ssh -L 5432:discovery.css2xhoreatp.us-west-2.rds.amazonaws.com:5432 bastion.twitch-ext-disco-dev.internal.justin.tv`

Will allow you to connect to the remote database via localhost:5432, assuming connections from the bastion host are allowed via the RDS security group configuration.


# Create bastion cluster via CLI

You can create the teleport-remote cluster yourself from the CLI!  This assumes you made [your sandstorm secret](https://wiki.twitch.com/display/SEC/Teleport+Remote#TeleportRemote-CreateanIAMroleinSandstorm) already
with the CLUSTER_NAME as your secret name.

```bash
< CLUSTER_NAME=twitch-jlindamo-personal AWS_PROFILE=twitch-jlindamo-personal ./create_bastion_cluster.sh 
{
    "UserId": "AROAJKYJCMB4MI5OPABUC:jlindamo-Isengard",
    "Account": "555125330048",
    "Arn": "arn:aws:sts::555125330048:assumed-role/admin/jlindamo-Isengard"
}

Waiting for changeset to be created..
Waiting for stack create/update to complete
Successfully created/updated stack - teleport-remote-twitch-jlindamo-personal
Done!

```

# Diagnosing Problems

Errors can sometimes be diagnosed by looking at the console log of the server created:
`aws ec2 get-console-output --instance-id <instance-id> --output text`

The instance-id is shown in the script output as shown above.

You can find your instance-id with a CLI command similar to this:
`AWS_PROFILE=twitch-goproxy-prod aws ec2 describe-instances --filters 'Name=tag:Name,Values=twitch-jump-host' --query Reservations[].Instances[].InstanceId --output text`

# Screenshots of a working setup

## LDAP host cloudformation stack
![alt text](imgs/ldap_host_cloudformation.png)
## Teleport-remote cloudformation stack
![alt text](imgs/teleport_remote_cf.png)
## VPC endpoint created via TPS
![alt text](imgs/vpc_endpoint.png)
## DNS name to resolve LDAP private link
![alt text](imgs/vpc_endpoint_dns.png)
## Login shown on cloudwatch logs
![alt text](imgs/login_in_logs.png)
## Your private link is in each subnet
![alt text](imgs/plink_subnets.png)
