# capreadonly

Creates the Capacity planning roles described on
[the wiki](https://wiki.twitch.com/display/AD/Capacity+planning+inventory+read+only+role+in+AWS+accounts).

It assumes your aws CLI works.  I recommend [isengard_credentials](https://git-aws.internal.justin.tv/twitch/isengard_credentials)
as a way to setup your CLI.


# How to use

## Check out this code
```bash
git clone git@git-aws.internal.justin.tv:twitch/capreadonly.git
cd capreadonly
```

## Execute the script
```bash
< AWS_PROFILE=twitch-querysuggest-prod ./create_capacity_role.sh 
Running for account id 377784251739
stack does not already exist.  Creating
Creating stack
{
    "StackId": "arn:aws:cloudformation:us-west-2:377784251739:stack/capacity-planning-readonly/8ca4a6d0-816d-11e9-a678-0a976e703682"
}
Waiting for stack to finish creating
Verifying role exists
{
    "Role": {
        "Path": "/",
        "RoleName": "twitch-inventory",
        "RoleId": "AROAVP5NSGVN5AGH7REJF",
        "Arn": "arn:aws:iam::377784251739:role/twitch-inventory",
        "CreateDate": "2019-05-28T17:25:17Z",
        "AssumeRolePolicyDocument": {
            "Version": "2012-10-17",
            "Statement": [
                {
                    "Effect": "Allow",
                    "Principal": {
                        "AWS": "arn:aws:iam::578510050023:role/twitch-inventory-master"
                    },
                    "Action": "sts:AssumeRole"
                }
            ]
        },
        "MaxSessionDuration": 3600
    }
}

```
