# twitch cli
Twitch Engineering CLI

## Installation

```
go get code.justin.tv/twitch/cli/cmd/...
```

## Usage

This command is a simple wrapper for sub-commands.


### Searching for sub-commands

If you name the repo for your subcommand as `twitch-cli-myfancycommand`, then it can
be easily found using one of these:

```
twitch cli search
twitch cli search myfancycommand
```

The output of `twitch cli search` includes a line that can be used to install the
sub-commands.

```
% twitch cli search
iduggan/twitch-cli-aws
	Twitch utilities for working against AWS
	go get -u code.justin.tv/iduggan/twitch-cli-aws/cmd/...

iduggan/twitch-cli-consul
	Twitch CLI plugin for consul search, etc.
	go get -u code.justin.tv/iduggan/twitch-cli-consul/cmd/...
```

There are a number of commands that will work fine with `twitch-cli`, but do not
use the discoverable repo format. Known examples include:

1. [kthornhill/twitch-rebuild](https://git-aws.internal.justin.tv/kthornhill/twitch-rebuild)
2. [Teleport Bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion) (shows up as `bastion`)


### Adding new commands

Any executable command which exists in `$PATH` and is prefixed with `twitch-` is eligible
to be a sub-command. Your command should respond to `-h` and have a brief description as
the first line in that output. If you use the help facilities of `spf13/cobra` or
`urfave/cli` it should work normally.

If you want to make your command discoverable on `git-aws`, name the repo something like
`twitch-cli-*`.

If you have a command in development, and don't want it discoverable yet, you can add
`[hide]` to the repo description on `git-aws` and it will be hidden.


### Known sub-commands

```
Twitch Engineering CLI. Get Shit Done.™

Usage:
  twitch [flags]
  twitch [command]

Available Commands:
  aws         CLI for working against AWS at Twitch
  bastion     Client configuration utility for Twitch's Teleport Bastion
  cli         Commands related to twitch-cli (search for new commands, etc.)
  consul      CLI for working with Consul
  help        Help about any command

Flags:
  -h, --help     help for twitch
  -H, --helppp   extended help (shows subcommands, recursively)

Use "twitch [command] --help" for more information about a command.


All Subcommands:

aws                 CLI for working against AWS at Twitch
   accounts         Manipulate accounts via Isengard
      create        Create accounts in Isengard
      list          List accounts in Isengard the caller is authorized an access to
   asg              Manipulate auto scale groups
      instances     List instances for an ASG
      list          List auto scale groups
      pssh          PSSH to all hosts
      ssh           SSH to a random host
   beanstalk        Manipulate beanstalk environments
      environments  List beanstalk app:environment pairs
      instances     List instances for an environment
      panic         upload a build to a beanstalk cluster, install bin/application, and bounce the servers
      pscp          PSCP files to all hosts
      pssh          PSSH to all hosts
      ssh           SSH to a random host
   codepipeline     Manipulate codepipelines clusters
      builds        List builds, optionally download as well (default list)
      pipelines     List pipelines in account
   creds            List or fetch into ~/.aws creds available in Isengard
   ec2              Manipulate ec2 instances
      ssh           SSH to an ec2 instance by instance id
   ecs              Manipulate ecs clusters
      clusters      List ECS clusters
      containers    List ECS containers
      services      List ECS services
   exec             Exec a command using an Isengard account ID and role
   help             Help about any command
bastion             Client configuration utility for Twitch's Teleport Bastion
   enable           Enable the Teleport Bastion
   disable          Disable the Teleport Bastion
   status           Show the current Teleport Bastion configuration status
   login            Manually log into the Teleport Bastion
   logout           Log out from the Teleport Bastion
   update           Update the Teleport Bastion configuration to include recent changes
   config           View and set local Teleport Bastion configuration parameters
   fix              Fix the Teleport Bastion configuration, if broken
   reset            Disable the Teleport Bastion and reset all configuration to defaults
   help, h          Shows a list of commands or help for one command
cli                 Commands related to twitch-cli (search for new commands, etc.)
   configure        Creates ~/.twitch/config.yml to hold credentials
   search           Search git-aws for twitch-cli subcommands.
consul              CLI for working with Consul
   help             Help about any command
   pssh             PSSH to all hosts
   search           Search consul for hosts and services
   ssh              SSH to a random host
help                Help about any command
```
