package main

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestExtractDescription(t *testing.T) {
	d0 := extractDescription(usage1)
	assert.Equal(t, "", d0)

	d1 := extractDescription(usage1)
	assert.Equal(t, "", d1)

	d2 := extractDescription(usage2)
	assert.Equal(t, "Exec a command using an Isengard account ID and role", d2)

	d3 := extractDescription(usage3)
	assert.Equal(t, "Client configuration utility for Twitch's Teleport Bastion", d3)
}

func TestExtractSubcommands(t *testing.T) {
	sc0 := extractDescription(usage1)
	assert.Equal(t, "", sc0)

	sc1 := extractSubcommands(usage1)
	assert.Equal(t,
		"configure   Creates ~/.twitch/config.yml to hold credentials\nsearch      Search git-aws for twitch-cli subcommands.\n",
		sc1,
	)

	sc2 := extractSubcommands(usage2)
	assert.Equal(t,
		"",
		sc2,
	)

	sc3 := extractSubcommands(usage3)
	assert.Equal(t,
		`enable   Enable the Teleport Bastion
disable  Disable the Teleport Bastion
status   Show the current Teleport Bastion configuration status
login    Manually log into the Teleport Bastion
logout   Log out from the Teleport Bastion
update   Update the Teleport Bastion configuration to include recent changes
config   View and set local Teleport Bastion configuration parameters
fix      Fix the Teleport Bastion configuration, if broken
reset    Disable the Teleport Bastion and reset all configuration to defaults
help, h  Shows a list of commands or help for one command
`,
		sc3,
	)
}

func TestExtractFlags(t *testing.T) {
	f0 := extractDescription(usage1)
	assert.Equal(t, "", f0)

	f1 := extractFlags(usage1)
	assert.Equal(t,
		"-h, --help   help for cli\n",
		f1,
	)

	f2 := extractFlags(usage2)
	assert.Equal(t,
		`-h, --help             help for exec
-p, --profile string   Provider to use, optionally in account:role format
`,
		f2,
	)

	f3 := extractFlags(usage3)
	assert.Equal(t, `--yes, -y      Assume a "yes" answer to all prompts
--help, -h     show help
--version, -v  print the version
`,
		f3,
	)
}

var usage0 = ""

var usage1 = `Usage:
  twitch cli [flags]
  twitch cli [command]

Available Commands:
  configure   Creates ~/.twitch/config.yml to hold credentials
  search      Search git-aws for twitch-cli subcommands.

Flags:
  -h, --help   help for cli
`

var usage2 = `Exec a command using an Isengard account ID and role

Usage:
  aws exec [flags]

Flags:
  -h, --help             help for exec
  -p, --profile string   Provider to use, optionally in account:role format
`

var usage3 = `NAME:
   teleport-bastion - Client configuration utility for Twitch's Teleport Bastion

USAGE:
   twitch-bastion [global options] command [command options] [arguments...]

VERSION:
   2.4.4

COMMANDS:
     enable   Enable the Teleport Bastion
     disable  Disable the Teleport Bastion
     status   Show the current Teleport Bastion configuration status
     login    Manually log into the Teleport Bastion
     logout   Log out from the Teleport Bastion
     update   Update the Teleport Bastion configuration to include recent changes
     config   View and set local Teleport Bastion configuration parameters
     fix      Fix the Teleport Bastion configuration, if broken
     reset    Disable the Teleport Bastion and reset all configuration to defaults
     help, h  Shows a list of commands or help for one command

GLOBAL OPTIONS:
   --yes, -y      Assume a "yes" answer to all prompts
   --help, -h     show help
   --version, -v  print the version
`
