/*
Package main implements the twitch command, a shell program similar to git.

Executing it such as `twitch my-command` will attempt to execute the binary
`twitch-my-command`, passing along any provided flags.

Executing it with the help option (-h) displays the full list of available
subcommands, with a one-line description of each.
*/
package main

import (
	"fmt"
	"os"

	"code.justin.tv/twitch/cli/cmd/twitch/cli"
)

func main() {
	rootCmd.AddCommand(cli.CliCmd)

	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
