package process

import (
	"fmt"
	"os"
	"os/exec"
	"syscall"

	"github.com/pkg/errors"
)

// Run runs the given command with args in a subshell
func Run(command string, args ...string) error {
	var err error

	cmd := exec.Command(command, args...)
	cmd.Stdin = os.Stdin
	cmd.Stdout = os.Stdout

	if err = cmd.Run(); err != nil {
		return errors.Wrap(err, fmt.Sprintf("There was an error running %s with %+v:", command, args))
	}

	return nil
}

// Exec execs the given command with args
func Exec(command string, args ...string) error {
	// find the binary for exec
	binary, lookErr := exec.LookPath(command)
	if lookErr != nil {
		panic(lookErr)
	}

	// when you exec, the first command is the binary name
	execArgs := []string{command}
	execArgs = append(execArgs, args...)

	err := syscall.Exec(binary, execArgs, os.Environ())
	if err != nil {
		return err
	}

	return nil
}

// Capture runs the given command with args in a subshell and returns the results
func Capture(command string, args ...string) ([]byte, error) {
	var err error

	cmd := exec.Command(command, args...)

	out, err := cmd.Output()
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("There was an error running %s with %+v:", command, args))
	}

	return out, nil
}
