# twitch/docs

**twitch/docs** is our internal wiki area for engineering-related documentation. Welcome!

Doc namespaces:

* Specific components:
  * **[Release](release/README.md)**: Branching, pushing, and deploying process docs.
  * **[Video](video/README.md)**: Those moving pictures that sometimes people watch on our site.
  * **[Web](web/README.md)**: Rails docs and general docs about web team responsibilities.
  * **[Stats](stats/README.md)**: Science and statsy stuff. Includes event documentation.
  * **[Javascript](javascript/)**: Client-side JavaScript architecture.
  * **[Chat and Messaging](chat_and_messaging/)**: Descriptions of chat and messaging systems.

* More general things:
  * **[Architecture](architecture/README.md)**: What are all the pieces, and how do they fit together?
  * **[Meta](meta/README.md)**: If you just can't get enough editing.
  * **[Style](style/README.md)**: Code styling guidelines.
  * **[Playbooks](playbooks/README.md)**: How to manage and debug the production and development sites.
  * **[New Engineer Spin-up](spinup/README.md)**: Getting new engineers hitting the ground running without tripping.

Important callouts:
 
* **Can't edit?** You're probably not on the [Engineering team][2]! Fix that by asking anyone on it to add you. Or ask in the #tech Slack channel! Make sure you're not in the tree view. Make sure you've clicked on a specific file to see the edit UI. 

## What goes in here?

Here are some examples of things that should go here:

* Spin-up guides
* Coding style guides
* Architectural overviews
* Code review, QA, and release guides

Things that *don't* belong here, but which instead belong in the repository they're related to (whose documentation can
then be linked to from here) include:

* API documentation
* Explanations of features which don't span multiple projects
* Spin-up guides for individual projects

## What am I allowed to edit?

**Everything.** No pull requests required.

### Okay, but what sorts of rules should I follow when editing?

We follow Wikipedia's *[ignore all rules][1]* philosophy: If a rule prevents you from improving or maintaining
docs, **ignore it**.

Editing wins *everything*. You should never encounter a situation in which you want to perform an edit, but avoid doing so
because you're afraid of breaking a rule (and can't be bothered to read them -- a completely legitimate excuse). **Edit
anyway**. Someone else will handle the other stuff -- don't worry about it.

If you have a deep and enchanting desire to be the "someone else" in that sentence, check out [meta](meta).

[1]: http://en.wikipedia.org/wiki/Wikipedia:Ignore_all_rules

### How should I edit?

Edit using github's web UI, or clone this repo and edit manually. Either works.

There is **no branching strategy** for this repo. Commit straight to master, merge in a branch, do a rebase, use github's web UI without caring what actually happens behind the scenes, whatever. Whatever's the easiest way for you to get your changes in, **do that**.

### I can't edit! Or, editing causes GitHub to fork the repo to my own account.

**Panic.** ![](https://static-cdn.jtvnw.net/jtv_user_pictures/emoticon-22998-src-455abddea2b94cc1-28x28.png) You probably need to be added to the [Twitch organization][2] on GitHub. Anyone on the org can add you, so ask anyone there. Feel free to ask in #web.

If you're not an engineer, we should add your team or your GitHub account to the Twitch org. Again, ask in #web!

[2]: https://git.xarth.tv/orgs/twitch/people
