# grpc services (in containerized beanstalks)

elastic beanstalk is very tightly tied to the idea of nginx listening on port 80 and proxy-passing connections to an http service listening on a virtual interface inside a container. unfortunately this is incompatible with services that want to talk over tcp and have a secondary port for pprofing.

to set up a grpc service, you'll want the following workarounds:
* [these](https://git.xarth.tv/video/digestion/blob/master/.ebextensions/01_haproxy.config) [two](https://git.xarth.tv/video/digestion/blob/master/.ebextensions/02_haproxy_setup.config) .ebextensions will give you haproxy over 9090 and 6060 to grpc and pprof. 
  * note that the client and server timeouts are set to one day, as grpc tends to want to hold open a connection over a long time. you can get away with shorter timeouts but it will just cause a ton of log churn and make dormant goroutines wake up to reconnect, which hurts your cpu usage.
  * also it doesn't check the grpc backend - if you have check turned on, it will open a tcp connection the server and immediately drop it, causing log spam.
* in the loadbalancer your beanstalk creates, increase its timeout from the default of 60. the maximum is 3600 - you need to strike a balance between unnecessary wakeups due to connections being broken and speed in rebalancing your load after autoscaling.
  * also add listeners for 80, 6060 and 9090, if you haven't already
* your ec2 instances need to be in security groups that allow traffic on 80, 6060 and 9090.
* we've been using [grpc-gateway](https://github.com/gengo/grpc-gateway) to generate json proxies for grpc services. nice thing to have as your http endpoint that beanstalk wants.
* use [proto-markdown](https://git.xarth.tv/common/proto-markdown) to generate a markdown description of your grpc service *automatically*
* we have an ami repo [here in video](https://git.xarth.tv/video/amis) which runs ldap for ssh, villagers, consul, and courier. build it with `packer build template.json`

