# Video

## ingest proxy 
A user starts by sending RTMP to `rtmp://live.twitch.tv/app/<stream_key>`. live.twitch.tv has DNS advertisements out of all of our pops, which then proxy the connection via anycast to SFO. 
## ingest (video/goingest, video/heartbeat)
A goingest server terminates the RTMP connection and notifies sidecar heartbeat that it has added a stream. Heartbeat calls Usher to authorize the stream [usher:POST/stream/authorize], which causes a job to be posted to RabbitMQ which will be picked up by a transcode or transmux worker. The goingest node periodically tells heartbeat to tell usher that it is still alive [usher:POST /node/update]
## hls transcode (video/workers, video/gotranscoder)
The transcode/transmux worker connects over RTMP to the goingest server and begins pulling video data and writing HLS files. 
## usher (video/usher)
Usher is the master coordinator of everything related to video. It is backed by usherdb, which is generally easier to use for one-off knowledge gathering than actually writing a http query
  - In the streams table, it lists each authorized ingest stream along with the user_properties which came back from web when authorizing. There are two streams for every fully functional stream - one for the live ingest, and one representing the HLS stream of the worker - check the 'format' column.
  - The hls_transcodes table represents the active transmux/transcode workers. Destination is a foreign key for the matching hls stream. Check the 'configuration' column for whether it's a transmux or transcode worker (transmux = chunked + audio_only)
  - the nodes table represents the live goingest servers. streams.origin is a foreign key for nodes.id.
  - the clusters table represents pops
  - the flows table represents replication paths. i don't really understand this anymore but there are replication daemons which run that insert flows between nodes for clusters that represent potential paths for receiving video. mostly this is important between pops.

Usher is sort of odd to read. To understand its route mapping, look for a dispatcher declaration near the top of the file. it may or may not use namespaced routes. For example, `api/channel_properties.py` is namespaced, `api/video_server.py` is not. in channel_properties, `def get_show(channel, **kwargs)` is exposed as the route `GET /channel_properties/show/<channel>?kwargs` in video_server, `def post_stream_authorize(request, **kwargs)` is exposed as `POST /stream/authorize?kwargs` with request representing the POST body (and it's sensitive to your content-type: but it ignores your accept: header in favor of what file extension your url path ends with). it also dispatches requests internally: `post_stream_authorize` calls `ev_dispatch("stream_authorize") which searches for methods named `ev_stream_authorize` and calls them, returning whatever the last matching function returned. In this case it only hits api/authorize_stream.py. I think this used to make more sense when you wanted to have multiple side effect functions defined in other files which would be triggered by a single api endpoint. 
it also does things like producing the top-level manifest for a stream, which uses our distributed find system to determine for viewers what is the best location for them to pull video from and signs the manifest. 

## videoshim (video/videoshim)
videoshim provides an api for the 'dirty' parts of the system (basically most of video) to talk to the 'clean' parts (most of web). Here it is used for stream authorization, which requires a lookup against a user id and user_properties. [Its routing is defined here](https://git.xarth.tv/video/videoshim/blob/master/main.go#L69), which is the closest available thing to a api definition. check out `handlers/auth_user_streamkey.go` to see how auth works.

## hls replication/edge (gatekeeper, nginx, varnish, systems/puppet, video/usher(replication daemon))
some combination of nginx and varnish servers cache/proxy segment playlists and .ts segments. i don't really understand this well but it works.

## jax (web/jax)
Jax periodically queries usher for data about streams and channel properties. it acts as a cache and does some transformation on usher's old and uncool api into something a bit more manageable. channel properties contains information like avc levels and profiles, which matters for platforms (i.e. some mobile devices can't watch High x264 profile streams). [here's an example request](http://jax-internal-elb.prod.us-west2.justin.tv/streams)

## kraken (web/web)
kraken is the rails api. it probably has a lot of different data backends, but the only one i know about is jax. [here's an example request that is a proxy of jax data](https://api.twitch.tv/kraken/streams)
