# include the base module
module "base" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//base"
}

# set the default AWS region to us-west-2 (this is where our direct connect is)
provider "aws" {
	region = "us-west-2"
}

# configure our connection to consul
provider "consul" {
	address = "consul.internal.justin.tv"
	# this refers to the consul datacenter to which we connect
	# the instances started by terraform get their datacenter from puppet
	datacenter = "sfo01"
}

# classify the node in puppet
module "puppet_instance" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/release/terraform.git//puppet_instance"
	cluster = "myapp"
	hostname_prefix = "myapp"
	instance_type = "t2.micro"
	owner = "myteam"
}

# register fqdn as an output variable
output "fqdn" {
	value = "${module.puppet_instance.fqdn}"
}
