#!/bin/bash

function usage {
  echo "reset-aws-password -u USERNAME (-v)"
}

function check_conditions {
  if [[ ! -f $(which aws) ]]; then  echo "You need to have AWS CLI setup to use this tool" && exit 1; fi
  if [[ ! -f $(which gist) ]]; then  echo "You need to have gist  CLI setup to use this tool (try 'brew install gist')" && exit 1; fi
}

while test $# != 0
do
    case "$1" in
    -v) VERBOSE=1 ;;
    -u) shift; USERNAME=$1 ;;
    --) shift; break;;
    -h)  usage ;;
    esac
    shift
done

check_conditions

PW=$(cat /dev/urandom  | head -c32 | base64)

echo "Updating user login profile"
aws iam update-login-profile --user-name $USERNAME --password $PW --password-reset-required

account=${AWS_PROFILE:-$AWS_DEFAULT_PROFILE}
echo "Creating gist..."
instructions="
* Login at https://$account.signin.aws.amazon.com/console
* Change password
* Setup 2-factor auth (MFA device)
* Blast off!


This gist was created by a script. Check it out here: https://git-aws.internal.justin.tv/twitch/docs/blob/master/aws/reset-aws-password.sh"
echo -e "Username: $USERNAME\nPassword: $PW\n$instructions" |GITHUB_URL=https://git-aws.internal.justin.tv/ gist -d "Temp creds for $USERNAME for $AWS_PROFILE" -p

if [[ $VERBOSE -eq "1" ]]; then
  echo $USERNAME
  echo $PW
fi
