Document last updated OCT 2015 - Possibly out of date, be extra careful on existing accounts. 

# Creating EC2 Instances with Terraform

## Background Information

Terraform will generally handle most of the details surrounding AWS and EC2
configuration automatically, but here are some explanations for those just
getting started with AWS and EC2. If you already have some AWS skills and you
just want to get started with Terraform, skip to
[the Terraform section](#terraform).

### Amazon Machine Images (AMIs)

AMIs are disk images taken from existing systems, which can then be used to
speed up the provisioning of new systems with the same content.

You should generally use the most recent `devtools-baseami-precise` AMI, which
has already completed a successful Puppet run.

Note: this is already included in the `base.tf` file

### Virtual Private Clouds (VPCs)

VPCs are private sections of EC2 which are directly connected to our internal
infrastructure.

We have three VPCs in our AWS account:

    production (vpc-0213b167) - 10.192.64.0/18
    development (vpc-1e13b17b) - 10.192.128.0/18
    science (vpc-0713b162) - 10.192.0.0/18

If you are not deploying services to production, you should use the
`development` VPC.

Note: this is already included in the `base.tf` file

### Security Groups (SGs)

Security Groups are sets of firewall rules which are applied to EC2 instances.
They control the flow of both inbound and outbound traffic based on host
addresses, protocols, and ports in a way similar to `iptables`.

We have two Security Groups created which allow access from our private network
without opening access from the outside world:

    twitch_subnets (sg-27d18d42) - for the production VPC
    twitch_subnets (sg-f1edb194) - for the development VPC

Note: this is already included in the `base.tf` file

## Terraform

Terraform is an open-source alternative to CloudFormation from Hashicorp. It
can be used to describe the entire set of resources required by a service (EC2
instances, ELBs, etc.) and then start them appropriately.

### Initial Setup

You can get the latest version of Terraform for your platform
[here](https://www.terraform.io/downloads.html).

For OSX, the package is a zip file containing binaries. Copy these to some
location in your `$PATH` environment variable, such as `/usr/local/bin`.

You can also get terraform via Homebrew:

    $ brew install terraform

Once you have Terraform installed, you can check the version:

    $ terraform -version
    Terraform v0.4.2

### Terraform Files

Terraform uses text files to describe infrastructure and to set variables.
These text files are called Terraform configurations and end in `.tf`. For the
full documentation on configuration files, see the upstream docs
[here](https://www.terraform.io/docs/configuration/index.html).

Most of our `.tf` files are stored in the
[`release/terraform`](https://git.xarth.tv/release/terraform)
repo and [`systems/terraform`](https://git.xarth.tv/systems/terraform).

The base configuration for our environment is stored in
[`base.tf`](https://git.xarth.tv/release/terraform/blob/master/base/base.tf).
This file contains the default VPCs, AMIs, and Security Groups used by most of
our instances. Other `.tf` files can include this file to avoid config
duplication.

You can find an example Terraform configuration file
[here](https://git.xarth.tv/twitch/docs/blob/master/aws/example.tf).
This configuration file will be used in this documentation to demonstrate the
basic Terraform flow.

### Starting Instances

Once you have `terraform` installed and ready, you can use the `example.tf`
configuration file in this repo to start an instance.

    # Download all required modules from Git
    $ terraform get -update
    
    # REVIEW CHANGES
    $ terraform plan

    # Apply the configuration changes (starts instances, databases, etc. as needed)
    $ terraform apply

Now you will need to provide a few values on the command line:

    provider.aws.access_key = <your AWS access key>
    provider.aws.secret_key = <your AWS secret key>

If you do not have AWS credentials, you will need to get set up there before
you can proceed.

#### Note: this will start an EC2 instance - be sure to terminate it later.

If you would like to avoid being prompted for credentials, you can export them
in your environment:

    export AWS_ACCESS_KEY_ID="YourAccessKey"
    export AWS_SECRET_ACCESS_KEY="YourSecretKey"
    
**Note**: Terraform 0.5.0 checks for credentials locally, so you don't need to
store them in your environment.

Terraform will now create your EC2 instance and corresponding DNS record. You
can now log into it with the FQDN printed on the command line. Enjoy!


### Terraform State Files

Terraform keeps track of what it has started through `.tfstate` files. These
files should be added to git so multiple people can collaborate on the same
service. `.tfstate` files are ignored in this directory, since the config file
included is only an example, but you should include these files in git when
building real services.

### Terraform with Git

In git you can configure .tfstate files to be considered binary files and to hide them from git diff. This will greatly cleanup your phabricator CRs, github PRs and git logs.

This can be accomplished by adding `terraform.tfstate* -diff merge=binary` to a file called `.gitattributes`.
