###### The Commerce Systems
# Domain Model and Language

This document enables discussion of commerce system components and behaviors between Product and Engineering by agreeing on language.

It also seeks to describe at a very high level the business processes we're concerned about: how objects may interact with and affect one another and how areas of functionality/responsibility map to major system boundaries.

## Definitions
### Catalog
###### Consumer
user, customer, purchaser
###### Product
collection of one or more (most often one) Product Variants that represent "pretty much the same thing"
###### Product Variant
versions of a Product that may have different benefits
###### Category
group of Products united by logical or business definition
###### Metadata
description, images, text, video
###### Benefit
attribute that enables different features or provides physical value to the Consumer

### Ownership
###### Entitlement
a record of a Benefit being attributed to a Consumer for a specific time interval
###### Grant
to entitle a set of Benefits to a Consumer for a specific time interval, i.e. to create an Entitlement
###### Revoke
to revert the changes created by a Grant
###### Order
a transaction. Typcially involves both paying and entitling. Contains Line Items.
###### Line Item
a description of a single Product Variant that an Order intends to entitle. Contains a Product Variant and an Ownership Ruleset to apply to it.
###### Ownership Rules
description of how to process Line Items in an Order. Consists of 3 components: Pricing Policy, Charging Policy, Vending Policy
###### Pricing Policy
amount that must be paid to entitle the Product Variant, usually monetary
###### Charging Policy
when or how often to charge the price
###### Vending Policy
if the specific charging policy is satisfied, expresses access to the Product Variant
###### Price
TBD

### Payments
###### Planning
deciding how to fund a payment requirement.
###### Fulfillment
collecting from (possibly multiple) sources of funding.
###### Billing Profile
links the external billing entities (objects in Recurly/Xsolla) to internal Order Id
###### Invoice
declaration of a charge due (e.g. $4.99, now, for this month)
###### Transaction History
collection of value exchange events on a single Invoice
###### Recurring
TBD
###### Do not renew (DNR)
TBD
###### Cancel
TBD
###### Refund
TBD

## Order Lifecycle

![Order Lifecycle](http://gravizo.com/g?
    digraph G {
        Start [shape=plaintext, label="*"];
        Start -> Placed [label="pricing policy applied\\navailability checked"];
        Placed -> ppOpen [label="payment plan created"];
        subgraph clusterPaymentProcessing {
            label="Payment Processing";
            ppOpen [label="Open"];
            ppPaid [label="Paid"];
            ppFailed [label="Failed"];
            ppOpen -> ppPaid [label="successfully charged"];
            ppOpen -> ppOpen [label="charge attempt failed temporarily"];
            ppOpen -> ppFailed [label="charge attempt failed permanently"];
            ppOpen -> ppFailed [label="pricing no longer valid"];
        }
        ppPaid -> enOpen [label="charging policy satisfied"];
        subgraph clusterEntitlement {
            label="Entitlement";
            enOpen [label="Open"];
            enFailed [label="Failed"];
            enEntitled [label="Entitled"];
            enOpen -> enFailed [label="no longer available"];
            enOpen -> enEntitled [label="vending policy applied"];
        }
        enEntitled -> Complete;
    }
)

## Major Systems Examples

This is a rough association of objects and behaviors to the systems that own them. This is not a technical specification for any of the discussed systems.

### Example Entities by System

![Entities](http://gravizo.com/g?
digraph G {
  node [shape=box];
  subgraph clusterCatalog {
    label="Catalog";
    b0 [label="Benefit"];
    b1 [label="Benefit"];
    b2 [label="Benefit"];
    b3 [label="Benefit"];
    b4 [label="Benefit"];
    subgraph clusterP0 {
      label="Product";
      pv0 [label="Product Variant"];
    }
    subgraph clusterP1 {
      label="Product";
      pv1 [label="Product Variant"];
    }
    subgraph clusterP2 {
      label="Product";
      p2 [shape=plaintext, label=<<table border="0" cellborder="1"><tr><td port="pv0">Product Variant</td></tr><tr><td port="pv1">Product Variant</td></tr><tr><td port="pv2">Product Variant</td></tr></table>>];
    }
    pv0 -> b0;
    pv0 -> b1;
    pv1 -> b0;
    pv1 -> b1;
    p2:pv0 -> b0;
    p2:pv0 -> b1;
    p2:pv1 -> b0;
    p2:pv1 -> b1;
    p2:pv1 -> b2;
    p2:pv2 -> b0;
    p2:pv2 -> b1;
    p2:pv2 -> b3;
    p2:pv2 -> b4;
  }
  subgraph clusterOwnership {
    label="Ownership";
    subgraph clusterOwnershipRules {
      label="Ownership Rules";
      OwnershipRules [shape=plaintext, label=<<table border="0" cellborder="1"><tr><td>PricingPolicy</td></tr><tr><td>ChargingPolicy</td></tr><tr><td>VendingPolicy</td></tr></table>>];
    }
  }
  OwnershipRules -> p2:pv0;
  subgraph clusterPayments {
    label="Payments";
    Planning;
    Fulfillment;
  }
}
)

### Example System Responsibilities

#### Catalog
- What is the Product for an Id?
  - What Variants are available on a Product?
- What Benefits does a Product Variant (or multiple Variants) have?

###### "Discovery" Features
- What Product Variants provide a specific Benefit on a specific Channel?

#### Ownership
- What Ownership Rulesets may be applied to a Product Variant?
  - to each line item (Variant) in an order?
- What is the Price of a Line Item (Product Variant-Ownership Ruleset)?

###### “Processing” Features
- How often and when must the Price be charged?
- Initiate the Payment Processing for an Order!
- Has the Charging Policy been satisfied for all Line Items in an Order?
- Entitle each Line Item-Product Variant in an Order!

###### “Entitlement” Features
- What benefits does a Consumer have on a Channel?

#### Payments
- Initialize attempts to pay for an Order!
- What payment methods should be processed in order to process an in-process Order, in order? (e.g. apply coupon, charge credit card for rest)
- What is the status of payments on an order? (May be interpreted by Ownership Charging Policies.)
- Stop attempts to pay for an Order! (This is failure, not DNR.)
