# Steps required to test Xsolla V3
These steps need to be performed on a daily basis if run in a staging environment because of the daily reset to production

> Note: Completing the checkout process requires callbacks. Make sure the staging environment you're using accepts requests from:
>
> service IPs: 159.255.220.240/28, 185.30.20.16/29, 185.30.21.0/24, 185.30.21.16/29
>
> office's IPs: 173.196.181.234, 185.30.23.18
>
> And that the Webhook URL setting under the Xsolla Paystation V3 sandbox project https://merchant.xsolla.com/projects/15262 is pointing at the same environment

## Testing a new TicketProduct

### 1. Create XsollaPlans

![XsollaPlans](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_003.png)

The XsollaPlan's *group\_id* identifies a set of plans that determine what varied pricing structures are available for all products assigned to that group. An example *group\_id* is `4.99` and the first plan would have a *price* of `499` (in cents) and a *month\_interval* of `1`; another plan would have the same *group\_id*, a different *price* like `2994` and a *month\_interval* of `6` (6 months at $4.99 per month = $29.94).

The automatically generated *plan\_id* is the concatenation of `{group\_id}\_{month\_interval}\_months`, e.g. `4.99\_1\_months` or `4.99\_3\_months`. Uniqueness is enforced on *plan\_id*.

### 2. Create TicketProduct

![TicketProducts](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_004.png)

There should be no change in the process to create a new TicketProduct with the exception of the `default_price`. Going forward prices for products will be limited to prices defined by XsollaPlans. If 1 month XsollaPlans exist with prices of 499, 799, and 1099, those will be the only available options for a product's price.

By default the assigned price and group is a $4.99 per 1 month plan. The TicketProduct form page has fields to select from supported prices and groups. (Added 5/1/15)

![Price and group](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_010.png)

### ~~3. Update TicketProduct group~~ (deprecated as of 5/1/15)

![Xsolla Plan](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_007.png)

The default group assigned to a TicketProduct will be a $4.99 per 1 month plan. At the bottom of the page showing the newly created TicketProduct page, there is an option to assign the product to a specific group.

### 4. Visit checkout page and make payment

![Checkout](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_005.png)

Depending on the experiment group and whether the appropriate OptionSwitch is enabled, certain payment options may not appear. 
If the owner of the product:

1. Has not chosen to accept international payments or
2. Has not signed the net payment contract amendment

Xsolla will not be an option and Recurly and PayPal will *always* be available regardless of the intended purchaser's experiment group.

![Experiments](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_009.png)

### 5. Verify PurchaseProfile and PurchasePayment objects exist

![PurchaseProfile and PurchasePayment](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_006.png)

Successful payments will create a PurchaseProfile and at least one PurchasePayment (depending on the `month\_interval` of the chosen plan for the product). Recent profiles and payments will appear at the top of their respective admin pages ([PurchaseProfile](https://external-staging-1-admin.dev.us-west2.twitch.tv/admin/purchase_profiles), [PurchasePayment](https://external-staging-1-admin.dev.us-west2.twitch.tv/admin/purchase_payments)) and they're easy to search for. The admin page for payments isn't too useful, so the best thing to do would be to find the relevant profile since associated payments will be listed at the bottom of the profile page.

## Testing an existing TicketProduct

For an existing TicketProduct, the only different step from the ones above is:

### 1a. Sync existing TicketProduct

![Sync](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_008.png)

For an un-synced product, the entry for *xsolla\_product\_id* will be empty and will include a link to sync to Xsolla. Clicking that link will send a request to Xsolla to sync the product (the default group is $4.99 per 1 month).

TicketProducts will now show both the *product ID* and assigned *group* so that it's clear why a product may or may not be showing the intended price(s).

![Products and Groups](https://git.xarth.tv/bhsieh/resources/raw/master/xsolla/instructions_011.png)

### 1b. Update TicketProduct group (see deprecated step 4 above)

New TicketProducts can be assigned a group from the creation form, but for existing projects that may have prices other than $4.99 per 1 month, this simpler form can be used to manually assign a product to a group.

# Troubleshooting

* _Flip the switches!_ OptionSwitches and ArbKeys prevent stuff from happening but may or may not hide admin interface options so they're usually a good first place to check to see why something may or may not be working as intended.
* _Rollbar_ will usually have some relevant errors
* What should I do if there are xsolla plans and products alreay exisiting in staging DB and I still can't see them during checkout process on staging env?
  * Find the ticket product that is registered with xsolla. Follow these steps
  * RUN `delete from xsolla_products where ticket_product_id=7269;`
 	* Go to admin on staging env click sync now from the ticket products page. This should sync this product with xsolla and make it available for purchase.

