README
=======
The [dashboard](http://grafana.prod.us-west2.justin.tv/dashboard/db/postgres-stats) monitors all of the postgres clusters that the d8a team is responsible for. It's a good view of the load on sitedb, and other postgres clusters at twitch.

If you want to see sitedb's load use these settings:
  * `cluster`: `rails-postgres`
  * `role`: `master` or `replica`
  * `hostname`: `All`
  * `database`: `justintv_prod`



Notes on how to use the [dashboard](http://grafana.prod.us-west2.justin.tv/dashboard/db/postgres-stats):
------------

   * you must select a `cluster`. it **cannot** be "All"
   * you must select a `role`. currently pg-stats is only using 'master' and 'replica'.
   * `hostname` **can** be All.
   * be sure the `database` is set to what you are trying to monitor

Dashboard contents
---------
* data shown generated by [pg-stats](https://git.xarth.tv/d8a/pg-stats)
* `pg-stats` emits said data to twitch's [graphite cluster](graphite.internal.justin.tv)
* the data is the format: `stats.postgres.$cluster.$role.$hostname.$database.*`
  * `pg-stats` formatting changed recently, and as a result there are namespace collisions in graphite for `stats.postgres.*`.
  * a resolution has been proposed [SYS-6882](https://twitchtv.atlassian.net/browse/SYS-6882)
  * a kludgey fix is to use a regex in grafana until we can nuke the older [whisper](http://graphite.readthedocs.org/en/latest/whisper.html) files from the graphite cluster


How to manipulate the contents of the dashboard
---------------

1. you must be logged into grafana.
  * click the circle icon in the top left of the screen
  * click sign in
  * click sign in with google
2. In the area circled in red:
  * Templating controls the bins that grafana will collect.
  * the bins currently are: `cluster`, `role`, `hostname`, `database`
  ![grafana settings](./grafanasettings.png)
3. If you were to click edit on the $cluster variable you'd see the below
  * name corresponds to the variable you can use later in graphs
  * query is the namespace in statsd you're interested in
  * regex allows for limited values
  * and it shows a preview of the results at the bottom
![grafana var](./templatedvar.png)

4. To edit a particular graph
  * click the graph title/top of the row to produce this menu, and click Edit.
  ![graph edit](./graphedit.png)
  * this brings up a new view with the graph in question, and a new edit window.
  ![graph contents1](./graphcontents.png)
  * To edit the contents of the graph, click `Metrics` and you can change the statsd path
    * also notice that it makes use of the bins that exist in the Templating screen (`cluster`, `role`, `hostname`, `database`)
    * `aliasByNode` is a built in function from grafana to tokenize and extract the 5th item from an array, built by tokenizing: `stats.postgres.rails-postgres.master.localhost.justintv_prod.relations.all.xact_commit`
    * if you want to manually edit the function you can click the tray icon on the right at the end of the query, and edit the string manually
