PG Healthcheck
=================

`pg-healthcheck` is a service which runs on all D8A-managed postgres and pgbouncer boxes- it opens multiple 
 health ports allowing the current health status of a postgres or pgbouncer port to be queries and reported.
 Currently, pg-healthcheck is used to trigger nagios alerts during pg resource downtimes, and also to
 redirect load from unhealthy ports in our ELBs.

Querying Health
-----------------
 
By default, pg-healthcheck lives on port `6545`.  It is possible for it to run on other ports via puppet
 configuration, but the health query port is 6545 for all known resources at the time of this writing.
 To query the health of an individual port, a `GET` request can be issued to `host:6545/port/<port>`.
 To query the health of all ports on a single host, a `GET` request can be issued to `host:6545/port/all`. 
 A response 200 indicates that the route from the port to the backend is currently healthy.  A message regarding the current qualitative
 status of the port (usually just "Healthy") and the last time the port was queried is also returned in
 the response body, for each port involved in the query.
  
Forced Status
--------------

It is possible to force a port to provide a particular health status regardless of the underlying state of the port. 
 Once pg-healthcheck starts up, it will create one folder for each of its listening ports in its working directory.
 The service's working directory is usually `/tmp`, but it is defined in puppet.  It will also create an `all` folder
 in that same directory.

To force a port to report unhealthy, ssh into the node and issue the following command: `sudo bash -c 'echo "Unhealthy Reason" > /tmp/<port>/unhealthy'`.
 You can also target this command at `/tmp/all/unhealthy` to mark all ports as unhealthy, or at `/tmp/<port>/healthy` to force
 a node to report as healthy.  The port will report appropriately and list your given healthy/unhealthy reason in the
 health query response body.  To return the port to its default behavior, simply delete the healthy/unhealthy file.  That can be
 performed with `rm /tmp/<port>/healthy`, `unhealthy`, `all`, etc.  Additionally, if you add a status force unhealthy
 file while a healthy file already exists (or vice-versa), pg-healthcheck will automatically delete the old file.
