Migration to an ELB and ASG setup in AWS
=======================

* Terraform new master, elb and asg
* provision new master from old master
  * update terraform for discovery-asg to [point to new master](https://git.xarth.tv/d8a/provisioning/blob/ML_discovery_prod_elb_asg_2/pg/twitch-web-aws/discovery-asg/discovery-asg-replica.tf#L162)
  * on new master: `./bin/provision-replica discovery-postgres-0d55b2d7.production.twitch-web-aws.us-west2.justin.tv`
* Failover to new master
  * update puppet
    * [change $servers to point to new replication hosts in ASG](https://git.xarth.tv/systems/puppet/blob/master/modules/discovery/manifests/haproxy/backend_discovery_database_slave_production.pp)
    * [set new master](https://git.xarth.tv/systems/puppet/blob/master/modules/discovery/manifests/haproxy/backend_discovery_database_master_production.pp#L5)
    * set new master_db in [cluster yaml](https://git.xarth.tv/systems/puppet/blob/master/hiera/cluster/discovery-postgres.yaml#L149)
    * move old master fqdn into new master fqdn
      * ```mv hiera/fqdn/discovery-postgres-0d55b2d7.production.twitch-web-aws.us-west2.justin.tv.yaml hiera/fqdn/discovery-postgres-<new-id>.production.twitch-web-aws.us-west2.justin.tv.yaml```
        * and in the new master, set `master_db` to the old master, and make sure the new master isn't labeled as a master in the fqdn file at this point. the new master should then be replicating from the old. 
  * notify discovery team to start writing to new master (writes should start failing)
  * run `/usr/lib/postgresql/<version>/bin/pg_ctl promote -D /etc/postgresql/<version>/main/` on new master
  * writes should resume
* bring down previous discovery nodes 
