Migration to an ELB and ASG setup in AWS
=======================

# Notes
The goal for this migration will be to have 2 elbs. One for master, and one for the replicas. The rationale is that we can give the 2 elb hostnames out to production teams, and then change the backing hardware at any time. Those sorts of migrations require much less coordination between teams, and could potentially be zero down time.

# Process

* Terraform new master, master elb, replica asg, and replica elb
* provision new master from old master
  * on new master: `./bin/provision-replica tmi-postgres-812672.sfo01.justin.tv`
* set `upstream_master` for ASG/replicas in terraform to new master
* bring up replicas in ASG
* move old master fqdn into new master fqdn
  * ```mv hiera/fqdn/tmi-postgres-812672.sfo01.justin.tv.yaml hiera/fqdn/tmi-postgres-<new-id>.production.twitch-chat-aws.us-west2.justin.tv.yaml```
  * and in the new master, set `master_db` to the old master, and make sure the new master isn't labeled as a master in the fqdn file at this point. the new master should then be replicating from the old. 
* have chat switch to new replica ELB
* update `hiera/cluster/tmi-postgres.yaml` to point to new master ELB
* at this point run `puppet agent --test --environment=ML_tmi_postgres_migration` on new nodes
* notify chat team to start writing to new master ELB (writes should start failing)
* run `/usr/lib/postgresql/<version>/bin/pg_ctl promote -D /etc/postgresql/<version>/main/` on new master
* writes should resume
* bring down previous chat nodes 
