# Search and DISCOvery

<img src="files/disco-ball-party.jpg" alt="Team Disco" height="150" />

 - [JIRA Board](https://twitchtv.atlassian.net/secure/RapidBoard.jspa?rapidView=298)
 - [Team Github](https://git.xarth.tv/discovery)
 - [AWS Account](https://twitch-discovery-aws.signin.aws.amazon.com/console)

## Services

<table>
	<thead>
		<tr>
			<th>Service</th>
			<th>Product Owner</th>
			<th>Description</th>
			<th style="min-width:150px">Resources</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td>Jax</td>
			<td>@jwang</td>
			<td>Service for caching Usher (livestream metadata)</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/web/jax">Github</a> <br />
				:rocket: <a href="http://clean-deploy.internal.justin.tv/#/web/jax">Deployments</a> <br />
				:bar_chart: <a href="http://grafana.internal.justin.tv/dashboard/db/jax">Grafana</a> <br />
				:bar_chart: <a href="https://ganglia-ec2.internal.justin.tv/?c=jax&m=load_one&r=hour&s=by%20name&hc=4&mc=2">Ganglia</a> <br />
				:computer: <a href="http://consul.internal.justin.tv/ui/dist/#/us-west2/services/jax-nginx?filter=jax">Consul</a> <br />
				<a href="http://jax-internal-elb.prod.us-west2.justin.tv">Load Balancer</a> <br />
				<a href="https://jenkins.internal.justin.tv/job/web-jax/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/Jax/">Rollbar</a>
			</td>
		</tr>
		<tr>
			<td>Discovery (Games DB)</td>
			<td>@hassaan-markhiani</td>
			<td>Service that allows you to get useful information about games and streams' game information.</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/web/discovery">Github</a> <br />
				:rocket: <a href="http://clean-deploy.internal.justin.tv/#/web/discovery">Deployments</a> <br />
				:bar_chart: <a href="http://grafana.internal.justin.tv/dashboard/db/discovery">Grafana</a> <br />
				:bar_chart: <a href="https://ganglia-ec2.internal.justin.tv/?c=discovery&m=load_one&r=hour&s=by%20name&hc=4&mc=2">Ganglia</a> <br />
				:computer: <a href="http://consul.internal.justin.tv/ui/dist/#/us-west2/services?filter=discovery">Consul</a> <br />
				<a href="https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#LoadBalancers:search=discovery">Load Balancers</a> (twitch-web-aws) <br />
				<a href="https://jenkins.internal.justin.tv/job/web-discovery/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/Discovery/">Rollbar</a>
			</td>
		</tr>
		<tr>
			<td>Recommendations (API)</td>
			<td>@???</td>
			<td></td>
			<td>
				:octocat: <a href="https://git.xarth.tv/discovery/recommendations">Github</a> <br />
				:rocket: <a href="https://clean-deploy.internal.justin.tv/#/discovery/recommendations">Deployments</a> (beanstalk)<br />
				:bar_chart: <a href="https://grafana.internal.justin.tv/dashboard/db/recommendations">Grafana</a> <br />
				Load Balancers:
				<ul>
					<li><a href="http://recommendations-prod-internal.us-west-2.elasticbeanstalk.com/">Production</a> <br /></li>
					<li><a href="http://recommendations-staging-internal.us-west-2.elasticbeanstalk.com/">Staging</a> <br /></li>
				</ul>
			</td>
		</tr>
		<tr>
			<td>Search</td>
			<td>@hassaan-markhiani</td>
			<td></td>
			<td>
				:octocat: <a href="https://git.xarth.tv/twitch/docs/blob/master/discovery/files/Search-Architecture-Overview.pdf">Github</a>  architecture diagram <br />
				:bar_chart: <a href="http://grafana.internal.justin.tv/dashboard/db/search-dashboard">Grafana</a> <br />
				<a href="https://www.runscope.com/radar/ji54ym1dcl3b/390fb8d6-78f0-40e3-8331-2d534acc322b/overview">Runscope</a> <br />
				Contacts: jeremy.bensadoun@algolia.com, nicolas.baissas@algolia.com
			</td>
		</tr>
		<tr>
			<td>SearchIndexer</td>
			<td>@hassaan-markhiani</td>
			<td>Service to consume search index messages from Kinesis and sending the index action to search services.</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/web/searchindexer">Github</a> <br />
				:rocket: <a href="http://clean-deploy.internal.justin.tv/#/web/searchindexer">Deployments</a> <br />
				:bar_chart: <a href="http://grafana.internal.justin.tv/dashboard/db/searchindexer">Grafana</a> <br />
				:computer: <a href="http://consul.internal.justin.tv/ui/dist/#/us-west2/services?filter=searchindexer">Consul</a> <br />
				<a href="http://jenkins.internal.justin.tv/job/web-searchindexer/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/SearchIndexer/">Rollbar</a>
			</td>
		</tr>
		<tr>
			<td>Coviews</td>
			<td>@tiffany-huang, @rpw, @jcfox</td>
			<td>Cron-based Python scripts for coview recommendation generation.</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/discovery/coviews-python">Github</a> <br />
				:rocket: <a href="http://clean-deploy.internal.justin.tv/#/discovery/coviews-python">Deployments</a> <br />
				:bar_chart: <a href="https://grafana.internal.justin.tv/dashboard/db/coviews-python">Grafana</a> <br />
				<a href="https://jenkins.internal.justin.tv/job/discovery-coviews-python/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/Coviews-Python/">Rollbar</a>
			</td>
		</tr>
		<tr>
			<td>Autohost</td>
			<td>@jwang</td>
			<td>Service for automatically hosting.</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/discovery/autohost">Github</a> <br />
				:rocket: <a href="https://clean-deploy.internal.justin.tv/#/discovery/autohost">Deployments</a> (beanstalk)<br />
				:bar_chart: <a href="https://grafana.internal.justin.tv/dashboard/db/autohost">Grafana</a> <br />
				Load Balancers:
				<ul>
					<li><a href="http://autohost-production.us-west-2.elasticbeanstalk.com/">Production</a> <br /></li>
					<li><a href="http://autohost-staging.us-west-2.elasticbeanstalk.com/">Staging</a> <br /></li>
				</ul>
				<a href="https://jenkins.internal.justin.tv/job/discovery-autohost/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/Autohost/">Rollbar</a>
			</td>
		</tr>
		<tr>
			<td>Similar Channels</td>
			<td>@jcfox, @jwang</td>
			<td>Service that powers the recommended streams feature.</td>
			<td>
				:octocat: <a href="https://git.xarth.tv/discovery/similar-channels">Github</a> <br />
				:rocket: <a href="https://clean-deploy.internal.justin.tv/#/discovery/similar-channels">Deployments</a> <br />
				:bar_chart: <a href="https://grafana.internal.justin.tv/dashboard/db/similar-channels">Grafana</a> <br />
				:computer: <a href="http://consul.internal.justin.tv/ui/dist/#/us-west2/services/deploy-target-similar-channels?filter=similar-channels">Consul</a> <br />
				Load Balancers:
				<ul>
					<li><a href="http://similar-channels-production.us-west2.twitch.tv/">Production</a> <br /></li>
					<li><a href="http://similar-channels-staging.us-west2.twitch.tv/">Staging</a> <br /></li>
				</ul>
				<a href="https://jenkins.internal.justin.tv/job/discovery-similar-channels/">Jenkins</a> <br />
				<a href="https://rollbar.com/Twitch/SimilarChannels/">Rollbar</a>
			</td>
		</tr>
    <tr>
      <td>Kalista</td>
      <td>@dliao, @tiffany-huang</td>
      <td>LOL metadata handling.</td>
      <td>
        :octocat: <a href="https://git.xarth.tv/discovery/kalista">Github</a> <br />
        :rocket: <a href="https://clean-deploy.internal.justin.tv/#/discovery/kalista">Deployments</a> (beanstalk)<br />
        :bar_chart: <a href="https://grafana.internal.justin.tv/dashboard/db/kalista">Grafana</a> <br />
        <a href="https://jenkins.internal.justin.tv/job/discovery-kalista/">Jenkins</a> <br />
        <a href="https://rollbar.com/Twitch/Kalista/">Rollbar</a>
      </td>
    </tr>
	</tbody>
</table>

### Useful Links
 - web stuff:
     - production [consul](http://consul.internal.justin.tv/ui/dist/#/us-west2/nodes?filter=rails-app-aws-)
     - [staging environments](https://docs.google.com/spreadsheets/d/1Unh6ySneYOb3nD8sM3Fy7yXv2hhzd-G197OG73ukfig/edit?pli=1#gid=0)
 - AWS accounts:
     - [twitch-discovery-aws](https://twitch-discovery-aws.signin.aws.amazon.com/console)
     - [twitch-web-aws](https://twitch-web-aws.signin.aws.amazon.com/console)
     - [twitch-web-dev](https://twitch-web-dev.signin.aws.amazon.com/console)
     - [twitch-aws](https://twitch-aws.signin.aws.amazon.com/console)
 - Instrumentation/Graphs/Stats:
     - [The USE Method](http://www.brendangregg.com/usemethod.html)
     - [Grafana graph styles](http://play.grafana.org/dashboard/db/graph-styles)
     - [Science docs](http://docs.sci.twitch.tv/)
 - Setting up a new host:
     - [Terraform](https://git.xarth.tv/twitch/docs/blob/master/siteinfra/new_service/deploy.md#pre-production-environments)
     - [Terraform variables](https://terraform.io/docs/configuration/variables.html)
 - [Oncall tool](https://git.xarth.tv/web/oncall) (useful for running commands on groups of hosts)
     - IMPORTANT: when dealing with AWS machines, be sure to set the the environment variable: CONSUL_DC=us-west2
 - [Runscope](https://www.runscope.com/radar/ji54ym1dcl3b?swt=radar)

## Notes

Date | Document
---- | --------
Oct 2015 | [Technical Vision and Roadmap](https://twitch.quip.com/Kba6AfTuqS7M)
Oct 2015 | [Elastic Search in AWS spec](https://docs.google.com/document/d/12Scy_RViOdPUBuCqahj9e1JBInrF2t9gtmJz0L8u7ic/edit)
Oct 2015 | [Whiteboard notes](files/IMG_5760.JPG)
