Identity Run Guide
==================
Congratulations, [INSERT NAME HERE], you have been chosen as a candidate for on call rotation for Identity services. This is a very important role with lots of responsibility. To help you get started and to ensure your continued success, this handy automated guide exists and will guide you through the journey of getting ready to be on call, being on call, and how to remember to relax.

# Getting Ready To Be On Call

The first step to being a successful on call engineer is to have the right accounts to be able to do the right things. So please ensure that 

1. You have a twitch-passport aws account
2. You have a [pagerduty](https://twitchoncall.pagerduty.com) account, with your primary phone number associated with it.
    1. Please ensure that you get calls/text messages. Emails can be lossy. Or install the Pagerduty App.
3. You can vpn into SFO from your home. 
4. You can ssh to Passport and Owl boxes.
5. You will be available with a computer during your on call rotation.

If you do not have any of these things please contact your manager.

Identity is comprised of 3 services:

1. Passport - service that renders and manipulates logic around forms that passwords are entered on. Think Login and Signup forms
2. Owl - service that grants and validates oAuth tokens. 
3. Parts of Rails - main web stack. Rails ties Passport, Owl, and the rest of the site together.

# Being On Call

Ok, you are on call. You get paged. Now what? First off Ack the pagerduty alert. If the problem is not obvious from the alert, look on the dashboards for [Owl](http://grafana.prod.us-west2.justin.tv/dashboard/db/owl) and [Passport](http://grafana.prod.us-west2.justin.tv/dashboard/db/passport). Once you determine the issue decide if you can fix it. If you cannot, escalate to your manager or the relevant team’s on call. 

## Passport

Passport lives and runs on AWS. You can sign in to the console [here](https://twitch-passport.signin.aws.amazon.com/).

Passport depends on 

1. Rails - Rails currently acts as the Database for user information. This will change soon.
2. Redis - Passport uses a redis cluster to track login attempts and to subsequently rate limit users with reCaptcha prompts.
3. Mixpanel, reCaptcha, Facebook, Spade, and Rollbar for various services. 

All dependencies should be wrapped in a hystrix circuit breaker. This should prevent catastrophic failure if these dependencies go down. 

Configuration for passport lives under the elasticbeanstalk console. If you go the web-passport->passport-prod->Configuration->Software Configuration then you should see the configuration options for passport. If you need to change the URL for redis you can do it here. 

ssh access to Passport production boxes is accomplished via your LDAP username. Simply look up the private ip address for a production box via the aws console and ssh to it. You must have your ssh key uploaded to the ldap [tool](https://dashboard.internal.justin.tv/ldaptools).

## Owl

Owl lives in the twitch-web-aws account. You can find the addresses of Owl hosts by using the oncall [tool](https://git.xarth.tv/web/oncall) or by using consul [search](https://git.xarth.tv/common/consul-search). 

Owl depends on :

1. Cassandra
2. SiteDB
3. DynamoDB (WIP)

We are currently in a project to consolidate the data store for the tokens in DynamoDB. Until that point all 3 of these databases are important. 

Configuration for Owl lives in [puppet](https://git.xarth.tv/systems/puppet/blob/master/modules/owl/manifests/init.pp). Changes should first be tried out on a single box then pushed from the master branch of puppet with `oncall puppet -g owl -u <ldap user>`.

ssh access to Owl production boxes can be accomplished via your LDAP username.  

# Remembering To Relax

JUST DO IT.

