## Addon pain points

Here are the pains that people have felt when working with addons, and
long-term plans to fix stuff.

- [x] **Allen** - Need to manually update Make Watch after making changes in
      ember addon (CRITICAL) **FIXED: See [isDevelopingAddon][is-developing-addon]**
- [ ] **Allen** - Difficult to implement global interactions that's not an
      addon yet (ie dropmenus)
- [ ] **Allen** - Pulling recent changes often unknowingly broke the dev
      environment. Doing one of the following usually fixed the issues but it's
      not well documented on why it's breaking and what needs to be done:
      - run `npm install` again
      - restart `make`
      - unlink and relink ember addon
- [ ] **Allen** - Having to manage web (css), web-client, and addons for design
      projects is overwhelming. Not sure if there's anything that can be done
      about this though but noting it anyways ¯\\_(ツ)_/¯

[is-developing-addon]: https://github.com/ember-cli/ember-cli/blob/master/ADDON_HOOKS.md#isdevelopingaddon

Additional Notes (organize later):
Max:
  * Setting up a proper dummy app should be a higher priority on projects that require coordination -- it is very difficult to keep design and API branches separate when design needs the API to be functional or mocked. Designing and developing on top of a dummy app also prevents the `make watch` not catching changes in addons issue, since you'll be working directly in the addon's dummy app instead.
  * Getting CSS out of web will alleviate some of these pain points -- the division between backend and frontend becomes much clearer once web-client or addons can own CSS.
  * Branchlab or any system that allows mix and matching of branches would also alleviate some of these pain points. In the mean time, dummy app.
  * Coordinating between multiple ICs across three repositories is difficult. We naturally want to avoid large, monolithic branches, but developing asynchronously across multiple branches is also difficult, with the formation of multiple test branches that can easily become obsolete or need frequent merges and pulls. API in particular can move very quickly; they can often be developed in small branches and merged into master independently. Front-end changes appear to be less flexible, being dependent on API being available and going out all at once as a single feature/product.
