# Install Ember Globally
if ```ember``` is not found:

``` npm install -g ember-cli ```

Concerns about versioning? Ember [defers to the project's version when available]( https://github.com/ember-cli/ember-cli/blob/master/bin/ember#L10-24)

Feel free to ```ember -v``` regardless, to double check.

# Creating an addon
In a new repository:

```
ember addon <addon-name>
```

# Installing an existing addon

In whatever repository you want to use the addon in:

``` ember install:addon <addon-name> ```

where ```<addon-name>``` is the git url, i.e.: ```git://git.internal.twitch.tv/web/<addon-name>```

Now when you run ```make watch``` (for web-client) it should install the addon (by adding it to the devDependencies in package.json).

# Local development
You have to run ```npm install``` and then 'change' a file to make the watcher pick up on the changes made to addon. Pushing to a branch and constantly running ```npm install``` is inconvenient.

http://www.ember-cli.com/#link-to-addon-while-developing

``` git clone git://git.xarth.tv/web/<addon-name> ```

Then, link it:

```
cd ~/twitch/<addon-name>
npm link
cd ~/twitch/web-client
npm link <addon-name>
```

And to web-client/package.json, add:

```
"devDependencies": {
  ...
  "<addon-name>": "*"
}
```

If you want to have ```make watch``` pick up changes to the addon you are developing, add the following to the addon's index.js:

```
isDevelopingAddon: function () {
  return true;
}
```

# Publishing
Edit web-client/package.json:

```
"devDependencies": {
  ...
  "<addon-name>": "<git-url>#<release>"
}
```
