## What is Linting? Why do we use it?

Code linting is a type of static analysis that is frequently used to find problematic patterns or code that doesn’t adhere to certain style guidelines. There are code linters for most programming languages, and compilers sometimes incorporate linting into the compilation process.

JavaScript, being a dynamic and loosely-typed language, is especially prone to developer error. Without the benefit of a compilation process, JavaScript code is typically executed in order to find syntax or other errors. Linting tools like ESLint allow developers to discover problems with their JavaScript code without executing it.

## Using ESLint

At Twitch, we use [ESLint](http://eslint.org/) as our linting tool. It is integrated directly into our `ember s` builds by generating linter tests via [`ember-cli-eslint`](https://github.com/ember-cli/ember-cli-eslint), which means it will also run automatically in Jenkins, allowing us to fail builds that throw linting errors. You can also run the linter by itself with `make lint` (in web-client) or by using the [`eslint`](http://eslint.org/docs/user-guide/getting-started#usage) command.

## Editor Config

Catching linting errors during our builds is a great way to prevent potential errors and inconsistent code from shipping to production. However, it's less than efficient for developers if we have to wait until we build the code to find out if there are errors. Fortunately, many editors have easy integrations with ESLint, allowing us to surface the errors while viewing the code itself. Below we've listed instructions for enabling this functionality in many of the most popular JavaScript editors:

### Atom

Install the [`linter-eslint`](https://atom.io/packages/linter-eslint) plugin
* `apm install linster-eslint`

### emacs

[Flycheck](http://www.flycheck.org/) supports ESLint with the [`javascript-eslint`](http://www.flycheck.org/manual/latest/Supported-languages.html#Javascript) checker.

### JetBrains IDEs (IntelliJ/WebStorm/etc)

JetBrains IDEs now ship with the ESLint plugin installed by default, it just needs to be [configured](https://www.jetbrains.com/help/webstorm/2016.1/eslint.html). Older versions of their IDEs can use this [third-party plugin](http://plugins.jetbrains.com/plugin/7494).

### Sublime Text

Install the [`SublimeLinter-contrib-eslint`](https://github.com/roadhump/SublimeLinter-eslint) plugin
1. Within Sublime Text, bring up the [Command Palette][cmd] and type `install`. Among the commands you should see `Package Control: Install Package`. If that command is not highlighted, use the keyboard or mouse to select it. There will be a pause of a few seconds while Package Control fetches the list of available plugins.

2. When the plugin list appears, type `eslint`. Among the entries you should see `SublimeLinter-contrib-eslint`. If that entry is not highlighted, use the keyboard or mouse to select it.

### vim

[Syntastic](https://github.com/scrooloose/syntastic) provides an [ESLint script](https://github.com/scrooloose/syntastic/tree/master/syntax_checkers/javascript/eslint.vim)

### VS Code

Install the [`vscode-eslint`](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint) plugin
* `ext install vscode-eslint`

### Other

Don't see your editor listed? Check out ESLint's [Integrations](http://eslint.org/docs/user-guide/integrations) list.
