# Common Issues

### No ember pages are loading

Disable Ad Block Plus. Yes, seriously.

### `make watch` doesn't work

This is a known issue for some versions of OSX. See [issue 2226](https://github.com/ember-cli/ember-cli/issues/2226) and [pull request 2458](https://github.com/ember-cli/ember-cli/pull/2458)

Workaround: `make build` every time you make changes to source files

### `Error: EMFILE, open 'blahblahblah.js'`

[You need more file descriptors.](http://blog.izs.me/post/56827866110/wtf-is-emfile-and-why-does-it-happen-to-me)

`ulimit -n 100000` will fix it in OS X Mavericks or earlier.

[These steps](http://superuser.com/questions/827984/open-files-limit-does-not-work-as-before-in-osx-yosemite) will fix it in OS X Yosemite.

### `Could not find watchman, falling back to NodeWatcher for file system events`

You need to install [watchman](https://facebook.github.io/watchman/). On Mac you can run `brew install watchman`.

### `invalid watchman found, version: [2.9.8] did not satisfy [^3.0.0], falling back to NodeWatcher`

Your copy of watchman is out of date. On Mac: `brew unlink watchman && brew install --HEAD watchman && watchman shutdown-server`.

### `FSEventStreamStart failed, look at your log file ...`

This is a known [issue](https://github.com/ember-cli/ember-cli/issues/2683) that occurs when running watchman for changes through Sublime Text.

Either restart your Sublime Text editor, or add `"tmp/*"` to your `"folder_exclude_patterns"` in your sublime-project file.

### `make watch` fails after deleting a file

Restart `make watch`. It grabs a list of files when it first starts and errors if any of them are missing.

### A module is undefined after adding an import

[Cyclic dependencies can cause modules to be imported as undefined](https://github.com/ember-cli/ember-cli/issues/1009)

Currently we are using window.App to hack in modules to where they're necessary (but can't be imported). See the comments in app/models/video.js and app/models/channel.js

### `make build` fails on Node v0.12.0

If you're on v0.12.0, you'll probably see an error message something along the lines of

> Cannot convert a Symbol value to a string

`git pull` latest master and try again.

### `make setup` returns `ECONFLICT Unable to find a suitable version for ...` while installing Bower packages

`make setup` suppresses prompts. Run `bower install` to manually resolve dependency version conflicts.

### `make setup` blows up on `bower install` when trying to install `twitch-styles`
```
npm ERR! twitch-styles@0.1.3 postinstall: `bower install --allow-root && grunt prod --env=prod`
npm ERR! Exit status 3
npm ERR! 
npm ERR! Failed at the twitch-styles@0.1.3 postinstall script 'bower install --allow-root && grunt prod --env=prod'.
```

Check your versions of node and npm.  You should be on node 4.3.x and npm 2.14.x.  To downgrade and clear out bindings from the previous version of node, run

```
brew unlink node
brew install homebrew/versions/node4-lts
npm run clean
```

## Testing
### Asynchronous Testing
If you are doing async work in your tests, you may get the error `"Uncaught Error: Assertion Failed: You have turned on testing mode, which disabled the run-loop's autorun. You will need to wrap any code with asynchronous side-effects in an run"`. In this case, do just that, and wrap your test code in an Ember.run.

### Cross-Origin Errors
Disable Chromecast extension
