### Deploying `web-client`

1. Create your feature branch and work on it.

   ```bash
   > git checkout master
   > git pull
   > git checkout -b add-doughnut-emoticon
   # hack hack hack
   > git push
   ```

2. When your code is production quality, use GitHub to open a new pull
   request:

   ![Opening a pull request](images/deploy-opening-a-pr.png)

   Be sure to write a clear description and add a primary reviewer.

   ![Writing a PR description](images/deploy-pr-description.png)

   **Note**: If you're having trouble finding a reviewer, feel free
   to drop a link in [the `#ember-crs` Slack channel][ember-crs-slack].

3. Work with your reviewer until you're both confident in the code.

  ![Respond to PR feedback](images/deploy-pr-comments.png)

4. Deploy to your staging environment [using the deploy tool][deploy-tool].
   Reserve an unoccupied staging environment by putting your name on the
   corresponding row in [the Staging Environments document][environments-doc].
   ![Deploying your branch to a staging env](images/deploy-environment.png)

5. Submit a QA request by emailing qa-request@twitch.tv:

   ![Writing a QA request](images/deploy-sample-qa-request.png)

   The QA team may take multiple days to test your branch depending on their
   backlog. If you don't get an ETA, you may follow up by posting in the [#qa
   slack channel][qa-slack]. While QA isn't required for every change, it's
   strongly recommended for user-facing features.

6. Once your pull request is approved & you've tested your code, you're ready
   to merge your code. **Merging your code automatically deploys it**.

   ![Merging a branch](images/deploy-merge-branch.png)

7. Once you click the "Merge pull request" button you will be prompted to
   enter a description for the merge commit. **This message will be included
   in deployment emails**, making it a great place to summarize changes at
   a high level.

8. Skadi bot will post in [#web-client][web-client-slack] when your branch has
   finished deploying:

   ![The Skadi bot will post a message in slack](images/deploy-skadi-message.png)

   Be sure to delete your branch once you're done.

   ![Deleting a branch in GitHub](images/deploy-deleting-branch.png)

   :sparkles: That's it!! :sparkles:

   ...usually :smirk:

   Please monitor Slack [#support][support-slack] and be responsive in case your
   deploy reveals a bug. If it does, see [Reverting A Deploy][reverting-a-deploy]

### Manually deploying during a freeze

1.  Merge your code to master. Only merge your code if you intend to deploy it.

2.  Wait for your code to build and show as complete in the deploy tool.

    ![Building master](images/master-branch-built.png)

3.  Unfreeze web-client. Copy the reason for the freeze.

    ![Unfreeze web-client](images/revert-unfreeze-prompt.png)

4.  Deploy the master branch to `clean-production` using the dropdown.

    ![Deploy to clean-production](images/deploy-clean-production.png)

5.  Once your code is deployed, restore the freeze with the original reason you copied earlier.

    ![Freeze web-client](images/revert-freeze-reason.png)

Please send any questions or feedback related to this doc to @yaymukund in
[#web-platform Slack][web-platform-slack] or via email to web-platform@twitch.tv
:doughnut:

[deploy-tool]: https://clean-deploy.internal.justin.tv/#/web/web-client
[reverting-a-deploy]: reverting-a-deploy.md
[ember-crs-slack]: https://twitch.slack.com/messages/ember-crs/
[qa-slack]: https://twitch.slack.com/messages/qa/
[environments-doc]: https://docs.google.com/spreadsheets/d/1Unh6ySneYOb3nD8sM3Fy7yXv2hhzd-G197OG73ukfig/edit
[support-slack]: https://twitch.slack.com/messages/support/
[web-platform-slack]: https://twitch.slack.com/messages/web-platform/
[web-client-slack]: https://twitch.slack.com/messages/web-client/
