# Experiments

If you need to AB test a feature, you can do by creating a new experiment. This
is a three step process:

1. [Create a new experiment in Minixperiment][create-experiment], the backend
service that handles experiments.

  ![](images/experiments-creation.png)

2. Add the experiment to the `EXPERIMENTS_UUID_MAP` and the `EXPERIMENT_DEFAULTS`
[in `web/web-client` upon initialization][minixperiment-initialization].


3. Use the experiment value in your application code:

```js
import injectService from 'ember-service/inject';

experiments: injectService(),
init() {
  this.get('experiments').getExperimentValue('NEW_SUBSCRIBE_BUTTON').then(group => {
    this.set('isNewSubscribeButton', group === 'new_button');
  });
}
```

Alternatively, you can also fetch the value from a template using the
`{{in-experiment-group}}` helper:

```hbs
{{#if (in-experiment-group 'NEW_SUBSCRIBE_BUTTON' 'new_button')}}
  <button class="new-fancy-button">...</button>
{{else}}
  <a class="old-button">...</a>
{{/if}}
```

## Rolling Out a Feature with Minixperiment

### Previewing Experiments

It's often useful to develop features in production behind a feature flag. You
can share your progress with your team and stakeholders by programmatically
setting a cookie in their browsers to force a certain feature variant.

Inside of the developer console:

```js
Twitch.experiments.overrideExperimentValue('MY_FEATURE', 'yes');
```

If you wish to reset your browser to a pristine feature state you can use:

```js
Twitch.experiments.clearOverrides();
```

You can even pass a URL to a teammate with the experiment variant encoded in the
query params.

```
https://www.twitch.tv/?experiments[my_experiment]=yes
```

### Launching a Staff Beta

Our configuration file for experiments includes [a section to place specific
variants that you want all staff members to see][staff-overrides]. Add your
feature and desired staff variant there. When your change is deployed, all staff
will receive your specified variant.

### Rolling out to a Custom Whitelist

There is currently no canonical way to rollout features to a custom whitelist of
users or to a specific user group (e.g. "partners only"). Anytime you want to
control who sees a feature based on some information known _after_ the
web-client loads you'll need to do some additional work. Your team will need to
provide an additional API to determine if a given user should see a feature and
add custom logic to web-client to reveal the UI.

You'll also need to do some custom work in web-client if you want to gradually
rollout a feature to staff beta without needing to redeploy web-client. In this
case you could create an experiment for staff beta in Minixperiment and a custom
service in web-client to check for the existence of the variant as well as the
user's staff access.

### Gradual Rollout to Twitch Users

Usually it's helpful to gradually introduce a feature to Twitch at large. This
mitigates the risk of overloading backend services and other unexpected
consequences of the broader rollout.

Inside of Minixperiment adjust the values of your experiment to increase the
variant you want and decrease the control variant. Save your changes and monitor
the impact. To make communication with your team easier it helps to make sure
that all the weights for your variants add up to 100.

As you adjust the weights, each user will [get an experiment
value][select-treatment] based on the following algorithm:

  1. Given the name of the experiment and the user's device ID, yield a
     weighting value for that user and experiment.
  2. With that pseudorandom value, assign a variant according to the provided
     wieghts.

The important thing to realize is that this process is deterministic. Each time
users visit the page they will have the same experiment variant as long as the
experiment name, the device ID, and the variant weights have not changed.
Furthermore, when the variant weights change users are not randomly shuffled
into new groups. Rather they slide between the variants deterministically based
on their pre-determined weighting value.

For instance, if Julie is in "no" and you increase the weight of "yes" by 1,
Julie may end up in "yes". If you then decrease the weight of "yes" by 1, Julie
will always return to "no". If you increase the weight of "yes" by 1 or more
from there, Julie will always end up in "yes".

```js
{ no: 20, yes: 80 } // Julie is in "no".
{ no: 19, yes: 81 } // Julie is in "yes".
{ no: 20, yes: 80 } // Julie is in "no" again
{ no: 15, yes: 85 } // Julie is in "yes" again
```

This means that we can gradually rollout features while giving users as
consistent an experience as possible.

## Removing an experiment

Once you've finished your experiment, removing it is a three step process:

1. Remove all references to your experiment in code.
2. Remove the experiment [from `experiments.js`'s][minixperiment-initialization] `EXPERIMENTS_UUID_MAP`,
   `EXPERIMENT_DEFAULTS` [(and the staff overrides, if it had staff overrides)][staff-overrides]
3. Archive the experiment in the minixperiment UI
  ![](images/experiments-archiving.png)

[create-experiment]: https://minixperiment.prod.us-west2.justin.tv/admin#/experiment/new
[minixperiment-initialization]: https://git.xarth.tv/web/web-client/blob/master/global/twitch/experiments.js
[staff-overrides]: https://git.xarth.tv/web/web-client/blob/a77d1d33a567105779f25bb398d37e59c04ebbf8/global/twitch/experiments.js#L110
[select-treatment]: https://git.xarth.tv/common/minixperiment-client-js/blob/2ab04600135a14eacda238e9cbdceb2d701641ab/lib/experiments.js#L118
