### So you broke production, huh?

Your priority is, in order:

1. Revert the deploy quickly to unbreak production.
2. Broadcast that production is broken.
3. Either push a fix or revert your branch entirely.

-------------------------------------------------------------------------------

Here's how you perform the steps:

1. Click the green arrow to display a list of commits.
   ![Click the green arrow to show the list of commits](images/revert-green-arrow.png)

   Deploy the last working commit.
   ![Deploy the last working commit](images/revert-deploy-old-commit.png)

2. **NOTE**: You've just deployed an older commit, but your breaking changes
   are still in the `master` branch. If someone redeploys `master`, the bug
   will reappear. For this reason, you should freeze the repository on
   [deploy][deploy-web-client]:

   ![Click the button to start the freezing process](images/revert-freeze-button.png)
   ![Provide relevant information and freeze the repository](images/revert-freeze-reason.png)

3. Create a new branch to fix the bug or revert your branch, whichever is
   fastest.

   a. Push a fix.

      ```bash
      > git checkout master
      > git checkout -b fix-doughnut-emoticon
      # hack hack hack
      > git commit
      > git push origin fix-doughnut-emoticon
      ```

   b. Push a revert.

      ```bash
      > git checkout master
      > git checkout -b revert-doughnut-emoticon
      > git log -1
      e8878a4 - (mukund/master) Add a doughnut emoji. [Mukund Lakshman] (24 minutes ago)

      > git revert HEAD -m 1
      [master aac4528] Revert "Add a doughnut emoji."
      1 file changed, 4 deletions(-)
      delete mode 100644 app/controllers/doughnut.js

      > git push origin revert-doughnut-emoticon
      ```

4. Deploy your fix/revert branch using
   [the deployment workflow][deployment-workflow]. You will be asked to
   unfreeze the repository, which you should at this point if you're deploying
   the fix:

   ![Unfreeze the repository](images/revert-unfreeze-prompt.png)

[deployment-workflow]: deployment.md
[deploy-web-client]: https://clean-deploy.internal.justin.tv/#/web/web-client
