### Stripping features from the web-client

Lets say we are developing a feature of a new video player  

1. Add your feature modules to `config/features.js` this module will be removed from the `emberapp.js`

  ```js
  module.exports = [
    'components/new-video-player/*.*'
  ]
  ```
  If you just want your code removed from `emberapp.js` you're done!

2. We need to obfuscate the feature so that we can lazy load our new code to our beta users. We are not going to discuss how to create the whitelist that is for another doc.

  We need to create a loader for our feature which will be shipped in the main build but give us a place to conditionally load the `new-video-player.`

  Also we need to gate the instantiation of the component in our code so that ember doesn't cache the module before it is loaded.

    the-template-loading-the-video-player.hbs
    ```hbs
      {{player-loader}}
    ```

    player-loader.hbs
    ```hbs
      {{#if shouldShowNewVideoPlayer}}
        {{new-video-player}}
      {{else}}
        {{video-player}}
      {{/if}}
    ```

    player-loader.js
    ```js
      export default Component.extend({
        shouldShowNewVideoPlayer: false,

        init() {
          this._super(...arguments);

            if(user.inTheWhitelist) {
              injectScript(`features.js`).then(() => {
                this.set('shouldShowNewVideoPlayer', true);
              });
            }
        }
      });
    ```

